/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WallJumpModule
implements Listener {
    private final Plugin plugin;
    private final Map<UUID, WallClimbState> playerStates;
    private final double slide_speed;
    private final double wall_jump_height;
    private final double wall_jump_distance;
    private final double wall_release_height;
    private final String slideParticle;
    private final String slideSound;
    private static final int STICK_DELAY_TICKS = 3;

    public WallJumpModule(Plugin plugin) {
        this.plugin = plugin;
        this.playerStates = new HashMap<UUID, WallClimbState>();
        this.slide_speed = plugin.getConfig().getDouble("wall_jump.slide_speed", 0.05);
        this.wall_jump_height = plugin.getConfig().getDouble("wall_jump.wall_jump_height", 0.7);
        this.wall_jump_distance = plugin.getConfig().getDouble("wall_jump.wall_jump_distance", 0.42);
        this.wall_release_height = plugin.getConfig().getDouble("wall_jump.wall_release_height", 0.5);
        this.slideParticle = plugin.getConfig().getString("wall_jump.slide_particle", "BLOCK");
        this.slideSound = plugin.getConfig().getString("wall_jump.slide_sound", "BLOCK_SAND_STEP");
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.wall_jump") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.wall_jump")) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (event.isSneaking()) {
            this.handleSneakStart(player, playerId);
        } else {
            this.handleSneakEnd(player, playerId);
        }
    }

    private boolean isPlayerOnGround(Player player) {
        Location loc = player.getLocation();
        Block blockBelow = loc.subtract(0.0, 0.1, 0.0).getBlock();
        return blockBelow.getType().isSolid();
    }

    private void handleSneakStart(Player player, UUID playerId) {
        if (!this.isPlayerOnGround(player) && this.isNextToWall(player)) {
            WallClimbState state = this.playerStates.computeIfAbsent(playerId, k -> new WallClimbState());
            BlockFace wallFace = this.getWallFace(player);
            if (wallFace != null) {
                this.initializeWallClimb(player, state, wallFace);
            }
        }
    }

    private void handleSneakEnd(Player player, UUID playerId) {
        WallClimbState state = this.playerStates.get(playerId);
        if (state != null && state.isStickingToWall && state.canWallJump) {
            this.performWallRelease(player);
            this.cancelTasks(state);
            this.playerStates.remove(playerId);
        }
    }

    private void initializeWallClimb(final Player player, final WallClimbState state, BlockFace wallFace) {
        state.wallFace = wallFace;
        state.initialY = player.getLocation().getY();
        state.canWallJump = true;
        this.cancelTasks(state);
        player.setVelocity(new Vector(0, 0, 0));
        state.stickDelayTask = new BukkitRunnable(){

            public void run() {
                if (player.isSneaking() && WallJumpModule.this.isNextToWall(player)) {
                    state.isStickingToWall = true;
                    WallJumpModule.this.startSlideTask(player, state);
                }
            }
        };
        state.stickDelayTask.runTaskLater(this.plugin, 3L);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.wall_jump") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.wall_jump")) {
            return;
        }
        UUID playerId = player.getUniqueId();
        WallClimbState state = this.playerStates.get(playerId);
        if (state != null && state.isStickingToWall && state.canWallJump) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            double yDiff = to.getY() - from.getY();
            if (yDiff > 0.1 && !this.isPlayerOnGround(player)) {
                this.performWallJump(player, state.wallFace);
                this.cancelTasks(state);
                this.playerStates.remove(playerId);
            }
        }
    }

    private void startSlideTask(final Player player, final WallClimbState state) {
        state.slideTask = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || !player.isSneaking() || !WallJumpModule.this.isNextToWall(player) || WallJumpModule.this.isPlayerOnGround(player)) {
                    WallJumpModule.this.cancelTasks(state);
                    WallJumpModule.this.playerStates.remove(player.getUniqueId());
                    this.cancel();
                    return;
                }
                if (state.isStickingToWall) {
                    WallJumpModule.this.keepPlayerAgainstWall(player, state.wallFace);
                    WallJumpModule.this.applySlideVelocity(player);
                }
            }
        };
        state.slideTask.runTaskTimer(this.plugin, 0L, 1L);
    }

    private void applySlideVelocity(Player player) {
        Particle particleType;
        Vector velocity = player.getVelocity();
        velocity.setY(-this.slide_speed);
        player.setVelocity(velocity);
        BlockFace wallFace = this.playerStates.get((Object)player.getUniqueId()).wallFace;
        Block wallBlock = player.getLocation().getBlock().getRelative(wallFace);
        try {
            particleType = Particle.valueOf((String)this.slideParticle.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            particleType = Particle.BLOCK;
        }
        if (wallBlock.getType().isSolid()) {
            if (particleType == Particle.BLOCK) {
                player.getWorld().spawnParticle(particleType, player.getLocation(), 8, 0.2, 0.2, 0.2, 0.1, (Object)wallBlock.getBlockData());
            } else {
                player.getWorld().spawnParticle(particleType, player.getLocation(), 8, 0.2, 0.2, 0.2, 0.1);
            }
        }
        Vitamin.getInstance().getVersionAdapter().playSlideSound(player.getLocation(), this.slideSound, 0.2f, 1.2f);
    }

    private void keepPlayerAgainstWall(Player player, BlockFace face) {
        Vector velocity = player.getVelocity();
        switch (face) {
            case NORTH: 
            case SOUTH: {
                velocity.setZ(0);
                break;
            }
            case EAST: 
            case WEST: {
                velocity.setX(0);
            }
        }
        player.setVelocity(velocity);
    }

    private void performWallJump(Player player, BlockFace wallFace) {
        float currentFallDistance = player.getFallDistance();
        Vector jumpVector = new Vector(0.0, this.wall_jump_height, 0.0);
        this.addHorizontalVelocity(jumpVector, wallFace, this.wall_jump_distance);
        switch (wallFace) {
            case NORTH: {
                jumpVector.setZ(-0.1);
                break;
            }
            case SOUTH: {
                jumpVector.setZ(0.1);
                break;
            }
            case EAST: {
                jumpVector.setX(0.1);
                break;
            }
            case WEST: {
                jumpVector.setX(-0.1);
            }
        }
        player.setVelocity(jumpVector);
        player.setFallDistance(currentFallDistance);
    }

    private void performWallRelease(Player player) {
        float currentFallDistance = player.getFallDistance();
        Vector jumpVector = new Vector(0.0, this.wall_release_height, 0.0);
        player.setVelocity(jumpVector);
        player.setFallDistance(currentFallDistance);
    }

    private void addHorizontalVelocity(Vector vector, BlockFace face, double wallJumpDistance) {
        switch (face) {
            case NORTH: {
                vector.setZ(wallJumpDistance);
                break;
            }
            case SOUTH: {
                vector.setZ(-wallJumpDistance);
                break;
            }
            case EAST: {
                vector.setX(-wallJumpDistance);
                break;
            }
            case WEST: {
                vector.setX(wallJumpDistance);
            }
        }
    }

    private boolean isNextToWall(Player player) {
        return this.getWallFace(player) != null;
    }

    private BlockFace getWallFace(Player player) {
        Location loc = player.getLocation();
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block block = loc.getBlock().getRelative(face);
            Block blockAbove = block.getRelative(BlockFace.UP);
            if (!this.isValidWallBlock(block) || !this.isValidWallBlock(blockAbove)) continue;
            return face;
        }
        return null;
    }

    private boolean isValidWallBlock(Block block) {
        return block.getType().isSolid() && !block.getType().equals((Object)Material.BARRIER);
    }

    private void cancelTasks(WallClimbState state) {
        if (state.slideTask != null && !state.slideTask.isCancelled()) {
            state.slideTask.cancel();
            state.slideTask = null;
        }
        if (state.stickDelayTask != null && !state.stickDelayTask.isCancelled()) {
            state.stickDelayTask.cancel();
            state.stickDelayTask = null;
        }
        state.isStickingToWall = false;
    }

    private static class WallClimbState {
        boolean isStickingToWall;
        BlockFace wallFace;
        BukkitRunnable slideTask;
        BukkitRunnable stickDelayTask;
        boolean canWallJump;
        double initialY;

        private WallClimbState() {
        }
    }
}

