/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.paper;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.text.modern.ModernLoggingUtils;
import com.soystargaze.vitamin.utils.text.modern.ModernTranslationHandler;
import java.awt.Color;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PaperDeathMapModule
implements Listener {
    private final JavaPlugin plugin;
    private final Component displayName;
    private final Component loreLine;
    private final MapView.Scale scale;

    public PaperDeathMapModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.displayName = ModernTranslationHandler.getComponent("death_map.map_item_name", new Object[0]);
        this.loreLine = ModernTranslationHandler.getComponent("death_map.map_item_lore", new Object[0]);
        this.scale = MapView.Scale.valueOf((String)plugin.getConfig().getString("death_map.map-scale", "NORMAL").toUpperCase());
        Bukkit.getScheduler().runTask((Plugin)plugin, this::reapplyRenderers);
    }

    private void reapplyRenderers() {
        for (short mapId : DatabaseHandler.getDeathMapIds()) {
            try {
                MapView view = Bukkit.getMap((int)mapId);
                if (view == null) continue;
                view.setTrackingPosition(true);
                view.setUnlimitedTracking(true);
                view.addRenderer(this.createDeathRenderer());
            }
            catch (Throwable t) {
                ModernLoggingUtils.logTranslated("death_map.map_renderer_error", mapId);
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!player.hasPermission("vitamin.module.death_map") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.death_map")) {
            return;
        }
        Location deathLoc = player.getLocation();
        DatabaseHandler.saveDeathLocation(player.getUniqueId(), deathLoc);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.death_map") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.death_map")) {
            return;
        }
        Location deathLoc = DatabaseHandler.getDeathLocation(player.getUniqueId());
        if (deathLoc == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            World world = deathLoc.getWorld();
            MapView view = Bukkit.createMap((World)world);
            view.setCenterX(deathLoc.getBlockX());
            view.setCenterZ(deathLoc.getBlockZ());
            view.setScale(this.scale);
            view.setTrackingPosition(true);
            view.setUnlimitedTracking(true);
            view.addRenderer(this.createDeathRenderer());
            DatabaseHandler.saveDeathMapId(player.getUniqueId(), (short)view.getId());
            ItemStack mapItem = new ItemStack(Material.FILLED_MAP, 1);
            MapMeta meta = (MapMeta)mapItem.getItemMeta();
            if (meta != null) {
                meta.displayName(this.displayName);
                meta.lore(List.of(this.loreLine));
                meta.setMapView(view);
                mapItem.setItemMeta((ItemMeta)meta);
            }
            player.getInventory().addItem(new ItemStack[]{mapItem});
            ModernLoggingUtils.sendMessage(player, "death_map.map_given", deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ());
            ModernLoggingUtils.logTranslated("death_map.map_given", deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ());
        });
    }

    @EventHandler
    public void onMapInitialize(MapInitializeEvent event) {
        short id = (short)event.getMap().getId();
        if (DatabaseHandler.getDeathMapIds().contains(id)) {
            MapView view = event.getMap();
            view.setTrackingPosition(true);
            view.setUnlimitedTracking(true);
            view.addRenderer(this.createDeathRenderer());
        }
    }

    private MapRenderer createDeathRenderer() {
        return new MapRenderer(this){
            private boolean rendered = false;

            public void render(@NotNull MapView mv, @NotNull MapCanvas canvas, @NotNull Player p) {
                int d;
                if (this.rendered) {
                    return;
                }
                int cx = 64;
                int cy = 64;
                Color black = new Color(0, 0, 0);
                Color white = new Color(255, 255, 255);
                for (d = -2; d <= 2; ++d) {
                    this.drawSquare(canvas, cx + d, cy + d, black);
                    this.drawSquare(canvas, cx + d, cy - d, black);
                }
                for (d = -1; d <= 1; ++d) {
                    canvas.setPixelColor(cx + d, cy + d, white);
                    canvas.setPixelColor(cx + d, cy - d, white);
                }
                this.rendered = true;
            }

            private void drawSquare(MapCanvas canvas, int x, int y, Color color) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        canvas.setPixelColor(x + dx, y + dy, color);
                    }
                }
            }
        };
    }
}

