/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.modules.core.CustomRecipesModule;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class ModuleCommand
implements CommandExecutor,
TabCompleter {
    private final Vitamin plugin;

    public ModuleCommand(Vitamin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            this.sendToSender(sender, "commands.pmodule.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("vitamin.module")) {
            TextHandler.get().sendMessage(player, "commands.module.no_permission", new Object[0]);
            return true;
        }
        if (args.length != 2) {
            TextHandler.get().sendMessage(player, "commands.module.usage", new Object[0]);
            return true;
        }
        try {
            Listener mod;
            Object key;
            boolean enable;
            ModuleManager moduleManager = this.plugin.getModuleManager();
            if (moduleManager == null) {
                this.plugin.getLogger().warning("ModuleManager is null, cannot reload modules.");
                return true;
            }
            String moduleName = args[0];
            String stateArg = args[1];
            if (stateArg.equalsIgnoreCase("enable")) {
                enable = true;
            } else if (stateArg.equalsIgnoreCase("disable")) {
                enable = false;
            } else {
                TextHandler.get().sendMessage(player, "commands.module.usage", new Object[0]);
                return true;
            }
            Object object = key = moduleName.startsWith("module.") ? moduleName : "module." + moduleName;
            if (!this.plugin.getConfig().contains((String)key)) {
                TextHandler.get().sendMessage(player, "commands.module.not_found", key);
                return true;
            }
            this.plugin.getConfig().set((String)key, (Object)enable);
            this.plugin.saveConfig();
            if ("module.custom_recipes".equalsIgnoreCase((String)key) && !enable && (mod = moduleManager.getModule("custom_recipes")) instanceof CustomRecipesModule) {
                ((CustomRecipesModule)mod).unregisterRecipes();
            }
            moduleManager.reloadModules();
            TextHandler.get().sendMessage(player, "commands.module.changed", key, enable ? "enabled" : "disabled");
        }
        catch (Exception e) {
            TextHandler.get().sendMessage(player, "commands.reload.error", new Object[0]);
            TextHandler.get().logTranslated("commands.reload.error", e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            if (this.plugin.getConfig().contains("module")) {
                Set keys = Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("module")).getKeys(false);
                for (String k : keys) {
                    suggestions.add("module." + k);
                }
            } else {
                for (String k : this.plugin.getConfig().getKeys(false)) {
                    if (!k.startsWith("module.")) continue;
                    suggestions.add(k);
                }
            }
        } else if (args.length == 2) {
            suggestions.add("enable");
            suggestions.add("disable");
        }
        return suggestions;
    }

    private void sendToSender(CommandSender sender, String key, Object ... args) {
        Object msg = TextHandler.get().getMessage(key, args);
        if (msg instanceof Component) {
            Component comp = (Component)msg;
            sender.sendMessage(comp);
        } else {
            sender.sendMessage(msg.toString());
        }
    }
}

