/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.modules.core.CustomRecipesModule;
import com.soystargaze.vitamin.utils.text.TextHandler;
import com.soystargaze.vitamin.utils.text.legacy.LegacyTranslationHandler;
import com.soystargaze.vitamin.utils.text.modern.ModernTranslationHandler;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
implements CommandExecutor,
TabCompleter {
    private final Vitamin plugin;

    public ReloadCommand(Vitamin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            this.sendToSender(sender, "commands.pmodule.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("vitamin.reload")) {
            TextHandler.get().sendMessage(player, "commands.reload.no_permission", new Object[0]);
            return true;
        }
        try {
            Listener mod;
            this.plugin.reloadConfig();
            ConfigHandler.reload();
            ModuleManager moduleManager = this.plugin.getModuleManager();
            boolean customEnabled = this.plugin.getConfig().getBoolean("module.custom_recipes", true);
            if (!customEnabled && (mod = moduleManager.getModule("custom_recipes")) instanceof CustomRecipesModule) {
                ((CustomRecipesModule)mod).unregisterRecipes();
            }
            moduleManager.reloadModules();
            int loadedTranslations = this.reloadTranslations();
            TextHandler.get().sendMessage(player, "commands.reload.success", loadedTranslations);
        }
        catch (Exception e) {
            TextHandler.get().sendMessage(player, "commands.reload.error", new Object[0]);
            TextHandler.get().logTranslated("commands.reload.error", e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        return new ArrayList<String>();
    }

    private int reloadTranslations() {
        String language = this.plugin.getConfig().getString("language", "en_us");
        if (Bukkit.getServer().getName().equalsIgnoreCase("Paper")) {
            ModernTranslationHandler.clearTranslations();
            ModernTranslationHandler.loadTranslations(this.plugin, language);
            return ModernTranslationHandler.getLoadedTranslationsCount();
        }
        LegacyTranslationHandler.clearTranslations();
        LegacyTranslationHandler.loadTranslations(this.plugin, language);
        return LegacyTranslationHandler.getLoadedTranslationsCount();
    }

    private void sendToSender(CommandSender sender, String key, Object ... args) {
        Object msg = TextHandler.get().getMessage(key, args);
        if (msg instanceof Component) {
            Component comp = (Component)msg;
            sender.sendMessage(comp);
        } else {
            sender.sendMessage(msg.toString());
        }
    }
}

