/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.commands.ModuleCommand;
import com.soystargaze.vitamin.commands.PModuleCommand;
import com.soystargaze.vitamin.commands.ReloadCommand;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VitaminCommand
implements CommandExecutor,
TabCompleter {
    private final ModuleCommand moduleCommand;
    private final PModuleCommand pModuleCommand;
    private final ReloadCommand reloadCommand;

    public VitaminCommand(Vitamin plugin) {
        this.moduleCommand = new ModuleCommand(plugin);
        this.pModuleCommand = new PModuleCommand(plugin);
        this.reloadCommand = new ReloadCommand(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            this.sendToSender(sender, "commands.pmodule.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("vitamin.use")) {
            TextHandler.get().sendMessage(player, "commands.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            TextHandler.get().sendMessage(player, "commands.usage", new Object[0]);
            return true;
        }
        String sub = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        return switch (sub) {
            case "reload" -> this.reloadCommand.onCommand(sender, command, label, subArgs);
            case "module" -> this.moduleCommand.onCommand(sender, command, label, subArgs);
            case "pmodule" -> this.pModuleCommand.onCommand(sender, command, label, subArgs);
            default -> {
                TextHandler.get().sendMessage(player, "commands.usage", new Object[0]);
                yield true;
            }
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            if (sender.hasPermission("vitamin.reload")) {
                subs.add("reload");
            }
            if (sender.hasPermission("vitamin.module")) {
                subs.add("module");
            }
            if (sender.hasPermission("vitamin.pmodule")) {
                subs.add("pmodule");
            }
            return subs;
        }
        if (args.length > 1) {
            String sub = args[0].toLowerCase();
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return switch (sub) {
                case "reload" -> this.reloadCommand.onTabComplete(sender, command, alias, subArgs);
                case "module" -> this.moduleCommand.onTabComplete(sender, command, alias, subArgs);
                case "pmodule" -> this.pModuleCommand.onTabComplete(sender, command, alias, subArgs);
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }

    private void sendToSender(CommandSender sender, String key, Object ... args) {
        Object msg = TextHandler.get().getMessage(key, args);
        if (msg instanceof Component) {
            Component comp = (Component)msg;
            sender.sendMessage(comp);
        } else {
            sender.sendMessage(msg.toString());
        }
    }
}

