/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.config;

import com.soystargaze.vitamin.Vitamin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigHandler {
    private static FileConfiguration config;
    private static String language;

    public static void setup(JavaPlugin plugin) {
        boolean created;
        File dataFolder = plugin.getDataFolder();
        if (!dataFolder.exists() && !(created = dataFolder.mkdirs())) {
            plugin.getLogger().severe("Could not create plugin data folder at " + dataFolder.getAbsolutePath());
            return;
        }
        File configFile = new File(dataFolder, "config.yml");
        YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)configFile);
        HashMap<String, Object> userValues = new HashMap<String, Object>();
        InputStream defaultStream = plugin.getResource("config.yml");
        if (defaultStream == null) {
            plugin.getLogger().severe("Default config.yml not found in plugin JAR!");
            return;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
        for (Object key : defaultConfig.getKeys(true)) {
            if (!oldConfig.contains((String)key)) continue;
            userValues.put((String)key, oldConfig.get((String)key));
        }
        plugin.saveResource("config.yml", true);
        YamlConfiguration mergedConfig = YamlConfiguration.loadConfiguration((File)configFile);
        for (Map.Entry entry : userValues.entrySet()) {
            mergedConfig.set((String)entry.getKey(), entry.getValue());
        }
        try {
            mergedConfig.save(configFile);
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error saving config.yml: " + e.getMessage());
        }
        config = mergedConfig;
        language = config.getString("language", "en_us");
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void reload() {
        Vitamin plugin = Vitamin.getInstance();
        plugin.reloadConfig();
        config = plugin.getConfig();
        language = config.getString("language", "en_us");
    }

    public static String getLanguage() {
        return language;
    }

    public static int getInt(String path, int def) {
        return config.getInt(path, def);
    }
}

