/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.integration;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldGuardIntegrationHandler {
    public WorldGuardIntegrationHandler(JavaPlugin plugin) {
    }

    public boolean canInteract(Player player, Location location) {
        try {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            LocalPlayer wgPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            com.sk89q.worldedit.util.Location weLoc = BukkitAdapter.adapt((Location)location);
            ApplicableRegionSet regionSet = query.getApplicableRegions(weLoc);
            if (regionSet.getRegions().isEmpty() || regionSet.getRegions().stream().allMatch(region -> region.getId().equalsIgnoreCase("__global__"))) {
                return true;
            }
            for (ProtectedRegion region2 : regionSet.getRegions()) {
                if (region2.getId().equalsIgnoreCase("__global__") || region2.getMembers().contains(wgPlayer.getUniqueId()) || query.testState(weLoc, wgPlayer, new StateFlag[]{Flags.INTERACT})) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canBuild(Player player, Location location) {
        try {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            LocalPlayer wgPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            com.sk89q.worldedit.util.Location weLoc = BukkitAdapter.adapt((Location)location);
            ApplicableRegionSet regionSet = query.getApplicableRegions(weLoc);
            if (regionSet.getRegions().isEmpty() || regionSet.getRegions().stream().allMatch(region -> region.getId().equalsIgnoreCase("__global__"))) {
                return true;
            }
            for (ProtectedRegion region2 : regionSet.getRegions()) {
                if (region2.getId().equalsIgnoreCase("__global__") || region2.getMembers().contains(wgPlayer.getUniqueId()) || query.testBuild(weLoc, wgPlayer, new StateFlag[0])) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

