/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.modules.core.ArmorTrimManager;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorTrimModule
implements Listener {
    private final Set<UUID> provokedPlayers = new HashSet<UUID>();
    private final ArmorTrimManager trimManager = new ArmorTrimManager();

    public ArmorTrimModule() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ArmorTrimModule.this.trimManager.updatePlayerTrims(player);
                    ArmorTrimModule.this.trimManager.applyEffects(player);
                }
            }
        }.runTaskTimer(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("Vitamin")), 0L, 20L);
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        Entity entity;
        if (event.getEntity() instanceof Piglin && (entity = event.getTarget()) instanceof Player) {
            Player player = (Player)entity;
            if (!player.hasPermission("vitamin.module.armor_trim") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.armor_trim")) {
                return;
            }
            if (!this.provokedPlayers.contains(player.getUniqueId()) && this.trimManager.hasGoldArmorTrim(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEntity() instanceof Piglin) {
                this.provokedPlayers.add(player.getUniqueId());
            }
        }
        this.trimManager.handleDamage(event);
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.trimManager.handleSneak(event.getPlayer(), event.isSneaking());
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        this.trimManager.handleExpChange(event);
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        this.trimManager.handleInventoryOpen(event);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        this.trimManager.handleGenericDamage(event);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        this.trimManager.handleEnchantItem(event);
    }
}

