/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class AutoToolModule
implements Listener {
    @EventHandler
    public void onBlockDamage(BlockDamageEvent event) {
        int slot;
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.auto_tool") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.auto_tool")) {
            return;
        }
        Material blockType = event.getBlock().getType();
        ToolType toolType = this.getToolTypeForBlock(blockType);
        if (toolType != null && (slot = this.findBestTool(player, toolType)) != -1 && player.getInventory().getHeldItemSlot() != slot) {
            player.getInventory().setHeldItemSlot(slot);
            this.spawnToolChangeParticles(player);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.hasPermission("vitamin.module.auto_tool") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.auto_tool")) {
            return;
        }
        int slot = this.findBestToolForSword(player);
        if (slot != -1 && player.getInventory().getHeldItemSlot() != slot) {
            player.getInventory().setHeldItemSlot(slot);
            this.spawnToolChangeParticles(player);
        }
    }

    private ToolType getToolTypeForBlock(Material block) {
        return switch (block) {
            case Material.STONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.DEEPSLATE, Material.TUFF, Material.CALCITE, Material.DRIPSTONE_BLOCK, Material.IRON_BLOCK, Material.GOLD_BLOCK, Material.DIAMOND_BLOCK, Material.NETHERITE_BLOCK, Material.EMERALD_BLOCK, Material.NETHERRACK, Material.END_STONE, Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS, Material.MAGMA_BLOCK, Material.OBSIDIAN, Material.CRYING_OBSIDIAN, Material.END_STONE_BRICKS, Material.SMOOTH_STONE, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.POLISHED_ANDESITE, Material.POLISHED_DIORITE, Material.POLISHED_GRANITE, Material.POLISHED_DEEPSLATE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.COPPER_BLOCK, Material.EXPOSED_COPPER, Material.WEATHERED_COPPER, Material.OXIDIZED_COPPER, Material.BASALT, Material.SMOOTH_BASALT, Material.BLACKSTONE, Material.POLISHED_BLACKSTONE, Material.NETHER_BRICKS, Material.CRACKED_NETHER_BRICKS, Material.CHISELED_NETHER_BRICKS, Material.RESPAWN_ANCHOR, Material.QUARTZ_BLOCK -> ToolType.PICKAXE;
            case Material.GRAVEL, Material.SAND, Material.RED_SAND, Material.DIRT, Material.PODZOL, Material.COARSE_DIRT, Material.GRASS_BLOCK -> ToolType.SHOVEL;
            case Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM, Material.STRIPPED_CRIMSON_STEM, Material.STRIPPED_WARPED_STEM, Material.OAK_WOOD, Material.SPRUCE_WOOD, Material.BIRCH_WOOD, Material.JUNGLE_WOOD, Material.ACACIA_WOOD, Material.DARK_OAK_WOOD, Material.STRIPPED_OAK_WOOD, Material.STRIPPED_SPRUCE_WOOD, Material.STRIPPED_BIRCH_WOOD, Material.STRIPPED_JUNGLE_WOOD, Material.STRIPPED_ACACIA_WOOD, Material.STRIPPED_DARK_OAK_WOOD, Material.CRIMSON_HYPHAE, Material.WARPED_HYPHAE, Material.STRIPPED_CRIMSON_HYPHAE, Material.STRIPPED_WARPED_HYPHAE, Material.OAK_PLANKS, Material.SPRUCE_PLANKS, Material.BIRCH_PLANKS, Material.JUNGLE_PLANKS, Material.ACACIA_PLANKS, Material.DARK_OAK_PLANKS, Material.CRIMSON_PLANKS, Material.WARPED_PLANKS, Material.OAK_STAIRS, Material.SPRUCE_STAIRS, Material.BIRCH_STAIRS, Material.JUNGLE_STAIRS, Material.ACACIA_STAIRS, Material.DARK_OAK_STAIRS, Material.CRIMSON_STAIRS, Material.WARPED_STAIRS, Material.OAK_SLAB, Material.SPRUCE_SLAB, Material.BIRCH_SLAB, Material.JUNGLE_SLAB, Material.ACACIA_SLAB, Material.DARK_OAK_SLAB, Material.CRIMSON_SLAB, Material.WARPED_SLAB, Material.OAK_FENCE, Material.SPRUCE_FENCE, Material.BIRCH_FENCE, Material.JUNGLE_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE, Material.CRIMSON_FENCE, Material.WARPED_FENCE, Material.OAK_FENCE_GATE, Material.SPRUCE_FENCE_GATE, Material.BIRCH_FENCE_GATE, Material.JUNGLE_FENCE_GATE, Material.ACACIA_FENCE_GATE, Material.DARK_OAK_FENCE_GATE, Material.CRIMSON_FENCE_GATE, Material.WARPED_FENCE_GATE, Material.OAK_DOOR, Material.SPRUCE_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_DOOR, Material.DARK_OAK_DOOR, Material.CRIMSON_DOOR, Material.WARPED_DOOR, Material.OAK_TRAPDOOR, Material.SPRUCE_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.JUNGLE_TRAPDOOR, Material.ACACIA_TRAPDOOR, Material.DARK_OAK_TRAPDOOR, Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.DARK_OAK_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON, Material.OAK_PRESSURE_PLATE, Material.SPRUCE_PRESSURE_PLATE, Material.BIRCH_PRESSURE_PLATE, Material.JUNGLE_PRESSURE_PLATE, Material.ACACIA_PRESSURE_PLATE, Material.DARK_OAK_PRESSURE_PLATE, Material.CRIMSON_PRESSURE_PLATE, Material.WARPED_PRESSURE_PLATE, Material.OAK_SIGN, Material.SPRUCE_SIGN, Material.BIRCH_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_WALL_SIGN, Material.BIRCH_WALL_SIGN, Material.JUNGLE_WALL_SIGN, Material.ACACIA_WALL_SIGN, Material.DARK_OAK_WALL_SIGN, Material.CRIMSON_WALL_SIGN, Material.WARPED_WALL_SIGN, Material.OAK_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN, Material.BIRCH_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN, Material.ACACIA_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN, Material.WARPED_HANGING_SIGN, Material.OAK_BOAT, Material.SPRUCE_BOAT, Material.BIRCH_BOAT, Material.JUNGLE_BOAT, Material.ACACIA_BOAT, Material.DARK_OAK_BOAT, Material.WARPED_WART_BLOCK, Material.WARPED_ROOTS, Material.OAK_CHEST_BOAT, Material.SPRUCE_CHEST_BOAT, Material.BIRCH_CHEST_BOAT, Material.JUNGLE_CHEST_BOAT, Material.ACACIA_CHEST_BOAT, Material.DARK_OAK_CHEST_BOAT, Material.CRIMSON_FUNGUS, Material.WARPED_FUNGUS, Material.BAMBOO_BLOCK, Material.BAMBOO_DOOR, Material.BAMBOO_SLAB, Material.BAMBOO_STAIRS -> ToolType.AXE;
            default -> null;
        };
    }

    private int findBestTool(Player player, ToolType type) {
        Material[] tools;
        switch (type.ordinal()) {
            case 0: {
                tools = new Material[]{Material.NETHERITE_PICKAXE, Material.DIAMOND_PICKAXE, Material.IRON_PICKAXE, Material.STONE_PICKAXE, Material.WOODEN_PICKAXE, Material.GOLDEN_PICKAXE};
                break;
            }
            case 1: {
                tools = new Material[]{Material.NETHERITE_AXE, Material.DIAMOND_AXE, Material.IRON_AXE, Material.STONE_AXE, Material.WOODEN_AXE, Material.GOLDEN_AXE};
                break;
            }
            case 2: {
                tools = new Material[]{Material.NETHERITE_SHOVEL, Material.DIAMOND_SHOVEL, Material.IRON_SHOVEL, Material.STONE_SHOVEL, Material.WOODEN_SHOVEL, Material.GOLDEN_SHOVEL};
                break;
            }
            default: {
                return -1;
            }
        }
        return this.findToolInInventory(player, tools);
    }

    private int findBestToolForSword(Player player) {
        Material[] swords = new Material[]{Material.NETHERITE_SWORD, Material.MACE, Material.TRIDENT, Material.DIAMOND_SWORD, Material.IRON_SWORD, Material.STONE_SWORD, Material.WOODEN_SWORD, Material.GOLDEN_SWORD};
        return this.findToolInInventory(player, swords);
    }

    private int findToolInInventory(Player player, Material[] desiredTools) {
        PlayerInventory inv = player.getInventory();
        int foundSlot = -1;
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null) continue;
            for (Material tool : desiredTools) {
                if (item.getType() != tool) continue;
                foundSlot = slot;
                break;
            }
            if (foundSlot != -1) break;
        }
        if (foundSlot == -1) {
            return -1;
        }
        if (foundSlot < 9) {
            return foundSlot;
        }
        int hotbarSlot = inv.getHeldItemSlot();
        ItemStack currentItem = inv.getItem(hotbarSlot);
        ItemStack bestTool = inv.getItem(foundSlot);
        inv.setItem(hotbarSlot, bestTool);
        inv.setItem(foundSlot, currentItem);
        return hotbarSlot;
    }

    private void spawnToolChangeParticles(Player player) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        player.getWorld().spawnParticle(Particle.SWEEP_ATTACK, loc, 3, 0.3, 0.3, 0.3, 0.01);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 0.2f, 1.2f);
    }

    private static enum ToolType {
        PICKAXE,
        AXE,
        SHOVEL;

    }
}

