/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.integration.LandsIntegrationHandler;
import com.soystargaze.vitamin.integration.LootinIntegrationHandler;
import com.soystargaze.vitamin.integration.WorldGuardIntegrationHandler;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class CarryOnModule
implements Listener {
    private final JavaPlugin plugin;
    private final double maxCarryWeight;
    private final NamespacedKey storedBlockKey;
    private final NamespacedKey chestPartKey;
    private final NamespacedKey chestIdKey;
    private WorldGuardIntegrationHandler wgIntegration;
    private LandsIntegrationHandler landsIntegration;
    private LootinIntegrationHandler lootinIntegration;
    private final boolean allowStacking;

    public CarryOnModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.maxCarryWeight = plugin.getConfig().getDouble("carry_on.max_weight", 100.0);
        this.allowStacking = plugin.getConfig().getBoolean("carry_on.allow_stacking", false);
        this.storedBlockKey = new NamespacedKey((Plugin)plugin, "stored_block");
        this.chestPartKey = new NamespacedKey((Plugin)plugin, "chest_part");
        this.chestIdKey = new NamespacedKey((Plugin)plugin, "chest_id");
        if (plugin.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.wgIntegration = new WorldGuardIntegrationHandler(plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("Lands") != null) {
            this.landsIntegration = new LandsIntegrationHandler(plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("Lootin") != null) {
            this.lootinIntegration = new LootinIntegrationHandler(plugin);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.getEntity().getScoreboardTags().contains("being_carried")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPickup(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player.hasPermission("vitamin.module.carry_on") && player.hasPermission("vitamin.module.carry_on.entity") && DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on"))) {
            return;
        }
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
            event.setCancelled(true);
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            return;
        }
        if (!(player.isSneaking() && player.getInventory().getItemInMainHand().getType().isAir() && player.getInventory().getItemInOffHand().getType().isAir())) {
            return;
        }
        if (entity instanceof Player) {
            boolean allowPickupPlayers = this.plugin.getConfig().getBoolean("carry_on.allow_player_pickup", false);
            if (!allowPickupPlayers || !player.hasPermission("vitamin.module.carry_on.entity.player")) {
                TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_players", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (!this.allowStacking) {
                if (!player.getPassengers().isEmpty()) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_while_carrying", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (player.getVehicle() != null) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_while_being_carried", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (!((Player)entity).getPassengers().isEmpty()) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_someone_carrying", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (entity.getVehicle() != null) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_someone_being_carried", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (!(entity instanceof LivingEntity)) {
            TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_entity", new Object[0]);
            event.setCancelled(true);
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.getScoreboardTags().contains("being_carried")) {
            TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_entity", new Object[0]);
            event.setCancelled(true);
            return;
        }
        AttributeInstance maxHPInstance = livingEntity.getAttribute(Vitamin.getInstance().getVersionAdapter().getMaxHPAttribute());
        if (maxHPInstance == null) {
            event.setCancelled(true);
            return;
        }
        double entityWeight = maxHPInstance.getBaseValue() * 2.0;
        if (entityWeight > this.maxCarryWeight) {
            TextHandler.get().sendMessage(player, "carry_on.entity_too_heavy", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.wgIntegration != null && !this.wgIntegration.canInteract(player, entity.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.landsIntegration != null && !this.landsIntegration.canInteract(player, entity.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        int slownessLevel = (int)Math.ceil(entityWeight / 15.0);
        this.applySlowness(player, slownessLevel);
        player.addPassenger(entity);
        entity.setGravity(false);
        entity.addScoreboardTag("being_carried");
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            monster.setAI(false);
        }
        TextHandler.get().sendMessage(player, "carry_on.picked_up_entity", entityWeight, this.maxCarryWeight);
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockPickup(PlayerInteractEvent event) {
        boolean allow;
        Player player = event.getPlayer();
        if (!(player.hasPermission("vitamin.module.carry_on") && player.hasPermission("vitamin.module.carry_on.chest") && DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on"))) {
            return;
        }
        if (!player.isSneaking() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!player.getInventory().getItemInMainHand().getType().isAir() || !player.getInventory().getItemInOffHand().getType().isAir()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Container)) {
            return;
        }
        if (this.lootinIntegration != null && this.lootinIntegration.isLootinContainer(block.getState()) && !(allow = this.plugin.getConfig().getBoolean("carry_on.allow_lootin_pickup", false))) {
            TextHandler.get().sendMessage(player, "carry_on.no_lootin_pickup", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.wgIntegration != null && !this.wgIntegration.canBuild(player, block.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.landsIntegration != null && !this.landsIntegration.canBreak(player, block.getLocation(), block.getType())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) {
            Chest chestData = (Chest)block.getBlockData();
            if (chestData.getType() == Chest.Type.SINGLE) {
                this.pickupSingleChest(player, block);
            } else {
                this.pickupDoubleChest(player, block);
            }
        } else {
            this.pickupSingleContainer(player, block);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityOrBlockDrop(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.carry_on") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on")) {
            return;
        }
        if (!(player.getPassengers().isEmpty() || event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK)) {
            this.releaseEntity(player);
            event.setCancelled(true);
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR || !item.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        if (!meta.getPersistentDataContainer().has(this.storedBlockKey, PersistentDataType.STRING)) {
            return;
        }
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock == null || !targetBlock.getType().isAir()) {
            return;
        }
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        String chestPart = (String)meta.getPersistentDataContainer().get(this.chestPartKey, PersistentDataType.STRING);
        if ((blockType == Material.CHEST || blockType == Material.TRAPPED_CHEST) && chestPart != null) {
            if (chestPart.equals("SINGLE")) {
                if (this.canPlaceChestAt(targetBlock, blockType)) {
                    this.placeSingleChest(player, targetBlock, meta);
                } else {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_place_chest", new Object[0]);
                }
            } else if (this.tryPlaceDoubleChest(player, targetBlock, meta, chestPart)) {
                TextHandler.get().sendMessage(player, "carry_on.placed_double_chest", new Object[0]);
            }
        } else {
            this.placeSingleContainer(player, targetBlock, meta);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        Player player;
        Entity entity;
        block5: {
            block4: {
                Entity dismounted = event.getDismounted();
                entity = event.getEntity();
                if (!(dismounted instanceof Player)) break block4;
                player = (Player)dismounted;
                if (entity instanceof Player) break block5;
            }
            return;
        }
        Player mountedPlayer = (Player)entity;
        if (mountedPlayer.getScoreboardTags().contains("being_carried")) {
            mountedPlayer.setGravity(true);
            mountedPlayer.removeScoreboardTag("being_carried");
            player.removePassenger((Entity)mountedPlayer);
            mountedPlayer.teleport(player.getLocation().add(0.0, 0.5, 0.0));
            this.removeSlowness(player);
            TextHandler.get().sendMessage(player, "carry_on.entity_dropped", new Object[0]);
            TextHandler.get().sendMessage(mountedPlayer, "carry_on.you_dismounted", new Object[0]);
        }
    }

    private boolean canPlaceChestAt(Block targetBlock, Material ignored) {
        return targetBlock.getType().isAir();
    }

    private void pickupSingleContainer(Player player, Block block) {
        ItemStack blockItem = new ItemStack(block.getType());
        ItemMeta itemMeta = blockItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        Container container = (Container)block.getState();
        meta.setBlockState((BlockState)container);
        meta.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)block.getType().name());
        blockItem.setItemMeta((ItemMeta)meta);
        block.setType(Material.AIR);
        player.getInventory().addItem(new ItemStack[]{blockItem});
        TextHandler.get().sendMessage(player, "carry_on.picked_up_block", block.getType().name().toLowerCase().replace("_", " "));
    }

    private void pickupSingleChest(Player player, Block block) {
        UUID chestId = UUID.randomUUID();
        Container container = (Container)block.getState();
        Inventory chestInventory = container.getInventory();
        this.saveChestContents(chestId, chestInventory);
        ItemStack blockItem = new ItemStack(block.getType());
        ItemMeta itemMeta = blockItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        meta.setBlockState((BlockState)container);
        meta.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)block.getType().name());
        meta.getPersistentDataContainer().set(this.chestPartKey, PersistentDataType.STRING, (Object)"SINGLE");
        meta.getPersistentDataContainer().set(this.chestIdKey, PersistentDataType.STRING, (Object)chestId.toString());
        blockItem.setItemMeta((ItemMeta)meta);
        chestInventory.clear();
        block.setType(Material.AIR);
        player.getInventory().addItem(new ItemStack[]{blockItem});
        TextHandler.get().sendMessage(player, "carry_on.picked_up_block", block.getType().name().toLowerCase().replace("_", " "));
    }

    private void pickupDoubleChest(Player player, Block block) {
        Block otherHalf = this.getConnectedChestBlock(block);
        if (otherHalf == null) {
            return;
        }
        UUID chestId = UUID.randomUUID();
        Container firstContainer = (Container)block.getState();
        Container secondContainer = (Container)otherHalf.getState();
        Inventory firstInventory = firstContainer.getInventory();
        ItemStack[] combinedContents = new ItemStack[54];
        System.arraycopy(firstInventory.getContents(), 0, combinedContents, 0, 27);
        System.arraycopy(secondContainer.getInventory().getContents(), 0, combinedContents, 27, 27);
        this.saveChestContents(chestId, combinedContents);
        ItemStack firstHalf = new ItemStack(block.getType());
        ItemMeta itemMeta = firstHalf.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta metaFirst = (BlockStateMeta)itemMeta;
        metaFirst.setBlockState((BlockState)firstContainer);
        metaFirst.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)block.getType().name());
        metaFirst.getPersistentDataContainer().set(this.chestPartKey, PersistentDataType.STRING, (Object)"LEFT");
        metaFirst.getPersistentDataContainer().set(this.chestIdKey, PersistentDataType.STRING, (Object)chestId.toString());
        firstHalf.setItemMeta((ItemMeta)metaFirst);
        ItemStack secondHalf = new ItemStack(block.getType());
        ItemMeta itemMeta2 = secondHalf.getItemMeta();
        if (!(itemMeta2 instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta metaSecond = (BlockStateMeta)itemMeta2;
        metaSecond.setBlockState((BlockState)secondContainer);
        metaSecond.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)block.getType().name());
        metaSecond.getPersistentDataContainer().set(this.chestPartKey, PersistentDataType.STRING, (Object)"RIGHT");
        metaSecond.getPersistentDataContainer().set(this.chestIdKey, PersistentDataType.STRING, (Object)chestId.toString());
        secondHalf.setItemMeta((ItemMeta)metaSecond);
        firstInventory.clear();
        secondContainer.getInventory().clear();
        block.setType(Material.AIR);
        otherHalf.setType(Material.AIR);
        player.getInventory().addItem(new ItemStack[]{firstHalf, secondHalf});
        TextHandler.get().sendMessage(player, "carry_on.picked_up_double_chest", new Object[0]);
    }

    private Block getConnectedChestBlock(Block block) {
        BlockFace[] faces;
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Chest relativeData;
            Block relative = block.getRelative(face);
            if (relative.getType() != block.getType() || (relativeData = (Chest)relative.getBlockData()).getType() == Chest.Type.SINGLE) continue;
            return relative;
        }
        return null;
    }

    private void placeSingleContainer(Player player, Block block, BlockStateMeta meta) {
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        block.setType(blockType);
        Container container = (Container)block.getState();
        container.setBlockData(meta.getBlockState().getBlockData());
        container.update(true, false);
        TextHandler.get().sendMessage(player, "carry_on.placed_block", new Object[0]);
        this.consumeItemInHand(player);
    }

    private void placeSingleChest(Player player, Block block, BlockStateMeta meta) {
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        block.setType(blockType);
        Container container = (Container)block.getState();
        container.setBlockData(meta.getBlockState().getBlockData());
        String chestIdStr = (String)meta.getPersistentDataContainer().get(this.chestIdKey, PersistentDataType.STRING);
        if (chestIdStr == null) {
            return;
        }
        UUID chestId = UUID.fromString(chestIdStr);
        Inventory chestInventory = container.getInventory();
        this.loadChestContents(chestId, chestInventory);
        this.deleteChestContents(chestId);
        container.update(true, false);
        TextHandler.get().sendMessage(player, "carry_on.placed_block", new Object[0]);
        this.consumeItemInHand(player);
    }

    private boolean tryPlaceDoubleChest(Player player, Block block, BlockStateMeta meta, String chestPart) {
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        String otherPart = chestPart.equals("LEFT") ? "RIGHT" : "LEFT";
        BlockFace[] otherChestItem = null;
        int otherChestSlot = -1;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            BlockStateMeta itemMeta;
            ItemMeta itemMeta2;
            BlockFace[] invItem = player.getInventory().getItem(i);
            if (invItem == null || invItem.getType() != blockType || !invItem.hasItemMeta() || !((itemMeta2 = invItem.getItemMeta()) instanceof BlockStateMeta) || !(itemMeta = (BlockStateMeta)itemMeta2).getPersistentDataContainer().has(this.chestPartKey, PersistentDataType.STRING) || !Objects.equals(itemMeta.getPersistentDataContainer().get(this.chestPartKey, PersistentDataType.STRING), otherPart)) continue;
            otherChestItem = invItem;
            otherChestSlot = i;
            break;
        }
        if (otherChestItem == null) {
            TextHandler.get().sendMessage(player, "carry_on.need_both_chest_parts", new Object[0]);
            return false;
        }
        Block otherBlock = null;
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block adjacent = block.getRelative(face);
            if (!adjacent.getType().isAir()) continue;
            otherBlock = adjacent;
            break;
        }
        if (otherBlock == null) {
            TextHandler.get().sendMessage(player, "carry_on.no_space_for_double_chest", new Object[0]);
            return false;
        }
        block.setType(blockType);
        otherBlock.setType(blockType);
        Container firstContainer = (Container)block.getState();
        Container secondContainer = (Container)otherBlock.getState();
        Chest firstChestData = (Chest)block.getBlockData();
        Chest secondChestData = (Chest)otherBlock.getBlockData();
        firstChestData.setType(chestPart.equals("LEFT") ? Chest.Type.LEFT : Chest.Type.RIGHT);
        secondChestData.setType(chestPart.equals("LEFT") ? Chest.Type.RIGHT : Chest.Type.LEFT);
        block.setBlockData((BlockData)firstChestData);
        otherBlock.setBlockData((BlockData)secondChestData);
        String chestIdStr = (String)meta.getPersistentDataContainer().get(this.chestIdKey, PersistentDataType.STRING);
        if (chestIdStr == null) {
            return false;
        }
        UUID chestId = UUID.fromString(chestIdStr);
        ItemStack[] combinedContents = new ItemStack[54];
        this.loadChestContents(chestId, combinedContents);
        Inventory firstInventory = firstContainer.getInventory();
        Inventory secondInventory = secondContainer.getInventory();
        firstInventory.setContents(Arrays.copyOfRange(combinedContents, 0, 27));
        secondInventory.setContents(Arrays.copyOfRange(combinedContents, 27, 54));
        this.deleteChestContents(chestId);
        firstContainer.update(true, false);
        secondContainer.update(true, false);
        this.consumeItemInHand(player);
        player.getInventory().setItem(otherChestSlot, null);
        return true;
    }

    private void consumeItemInHand(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    private void releaseEntity(Player player) {
        if (player.getPassengers().isEmpty()) {
            return;
        }
        player.getPassengers().forEach(entity -> {
            entity.setGravity(true);
            entity.removeScoreboardTag("being_carried");
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                monster.setAI(true);
            }
            if (entity instanceof Player) {
                Player mountedPlayer = (Player)entity;
                mountedPlayer.setGravity(true);
            }
            player.removePassenger(entity);
            entity.teleport(player.getLocation().add(0.0, 0.5, 0.0));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Entity)entity).eject(), 1L);
        });
        this.removeSlowness(player);
        TextHandler.get().sendMessage(player, "carry_on.entity_dropped", new Object[0]);
    }

    private void applySlowness(final Player player, int level) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, level - 1, false, false));
        new BukkitRunnable(){

            public void run() {
                if (player.getPassengers().isEmpty()) {
                    CarryOnModule.this.removeSlowness(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void removeSlowness(Player player) {
        player.removePotionEffect(PotionEffectType.SLOWNESS);
    }

    private void saveChestContents(UUID chestId, Inventory chestInventory) {
        String sql = "INSERT INTO chest_contents (chest_id, slot, item_data) VALUES (?, ?, ?)";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (int slot = 0; slot < chestInventory.getSize(); ++slot) {
                ItemStack item = chestInventory.getItem(slot);
                if (item == null) continue;
                String itemData = this.serializeItemStack(item);
                ps.setString(1, chestId.toString());
                ps.setInt(2, slot);
                ps.setString(3, itemData);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.save_error", e);
        }
    }

    private void saveChestContents(UUID chestId, ItemStack[] contents) {
        String sql = "INSERT INTO chest_contents (chest_id, slot, item_data) VALUES (?, ?, ?)";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (int slot = 0; slot < contents.length; ++slot) {
                ItemStack item = contents[slot];
                if (item == null) continue;
                String itemData = this.serializeItemStack(item);
                ps.setString(1, chestId.toString());
                ps.setInt(2, slot);
                ps.setString(3, itemData);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.save_error", e);
        }
    }

    private void loadChestContents(UUID chestId, Inventory chestInventory) {
        String sql = "SELECT slot, item_data FROM chest_contents WHERE chest_id = ?";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, chestId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int slot = rs.getInt("slot");
                    String itemData = rs.getString("item_data");
                    ItemStack item = this.deserializeItemStack(itemData);
                    chestInventory.setItem(slot, item);
                }
            }
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.load_error", e);
        }
    }

    private void loadChestContents(UUID chestId, ItemStack[] contents) {
        String sql = "SELECT slot, item_data FROM chest_contents WHERE chest_id = ?";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, chestId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int slot = rs.getInt("slot");
                    String itemData = rs.getString("item_data");
                    ItemStack item = this.deserializeItemStack(itemData);
                    if (slot >= contents.length) continue;
                    contents[slot] = item;
                }
            }
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.load_error", e);
        }
    }

    private void deleteChestContents(UUID chestId) {
        String sql = "DELETE FROM chest_contents WHERE chest_id = ?";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, chestId.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.delete_error", e);
        }
    }

    private String serializeItemStack(ItemStack item) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", (Object)item);
        return config.saveToString();
    }

    private ItemStack deserializeItemStack(String itemData) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(itemData);
            return config.getItemStack("item");
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("database.chest.deserialize_error", e);
            return null;
        }
    }
}

