/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.Effect;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

class FireResistanceEffect
implements Effect {
    private final int duration;
    private final int cooldown;
    private final Map<UUID, Long> lastAppliedMap = new HashMap<UUID, Long>();

    public FireResistanceEffect(int duration, int cooldown) {
        this.duration = duration;
        this.cooldown = cooldown;
    }

    @Override
    public void apply(Player player, int stack) {
        long now = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        Long lastApplied = this.lastAppliedMap.get(uuid);
        if (lastApplied == null || now - lastApplied >= (long)this.cooldown * 1000L) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, this.duration * 20 * stack, 0));
            this.lastAppliedMap.put(uuid, now);
            player.getWorld().spawnParticle(Particle.FLAME, player.getLocation(), 10 * stack, 0.5, 0.5, 0.5, 0.1);
        }
    }
}

