/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

class MagnetEffect
implements Effect {
    private final double baseRadius;

    public MagnetEffect(double baseRadius) {
        this.baseRadius = baseRadius;
    }

    @Override
    public void apply(Player player, int stack) {
        double radius = this.baseRadius * (double)stack;
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), radius, radius, radius)) {
            if (!(entity instanceof Item)) continue;
            Vector direction = player.getLocation().toVector().subtract(entity.getLocation().toVector()).normalize();
            entity.setVelocity(direction.multiply(0.1));
            Location itemLoc = entity.getLocation();
            Location playerLoc = player.getLocation();
            Vector particleDir = playerLoc.toVector().subtract(itemLoc.toVector()).normalize();
            for (double i = 0.0; i < itemLoc.distance(playerLoc); i += 0.5) {
                Location particleLoc = itemLoc.clone().add(particleDir.clone().multiply(i));
                player.getWorld().spawnParticle(Particle.CRIT, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

