/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public final class ReplanterModule
implements Listener {
    private static final Map<Material, CropInfo> CROP_INFO = new EnumMap<Material, CropInfo>(Material.class);

    @EventHandler
    public void onCropInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        CropInfo cropInfo = CROP_INFO.get(blockType);
        if (cropInfo == null) {
            return;
        }
        if (!this.isCropMature(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.seed_replanter") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.seed_replanter")) {
            return;
        }
        Material seedType = cropInfo.seedType();
        event.setCancelled(true);
        this.removeSeedFromInventory(player, seedType);
        this.harvestCrop(block, player, seedType);
        block.setType(blockType);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            ageable.setAge(0);
            block.setBlockData((BlockData)ageable);
        }
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_CROP_BREAK, 1.0f, 1.0f);
        block.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, block.getLocation().add(0.5, 1.0, 0.5), 10, 0.2, 0.2, 0.2, 0.0);
    }

    private void harvestCrop(Block block, Player player, Material seedType) {
        Collection drops = block.getDrops(new ItemStack(Material.WOODEN_HOE));
        Iterator iterator = drops.iterator();
        while (iterator.hasNext()) {
            ItemStack drop = (ItemStack)iterator.next();
            if (drop.getType() != seedType) continue;
            int amount = drop.getAmount();
            if (amount > 1) {
                drop.setAmount(amount - 1);
                break;
            }
            iterator.remove();
            break;
        }
        for (ItemStack item : drops) {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    private boolean isCropMature(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() >= ageable.getMaximumAge();
        }
        return false;
    }

    private void removeSeedFromInventory(Player player, Material seedType) {
        ItemStack seedItem;
        int seedSlot = player.getInventory().first(seedType);
        if (seedSlot >= 0 && (seedItem = player.getInventory().getItem(seedSlot)) != null && seedItem.getAmount() > 0) {
            seedItem.setAmount(seedItem.getAmount() - 1);
        }
    }

    static {
        CROP_INFO.put(Material.WHEAT, new CropInfo(Material.WHEAT_SEEDS));
        CROP_INFO.put(Material.CARROTS, new CropInfo(Material.CARROT));
        CROP_INFO.put(Material.POTATOES, new CropInfo(Material.POTATO));
        CROP_INFO.put(Material.BEETROOTS, new CropInfo(Material.BEETROOT_SEEDS));
    }

    private record CropInfo(Material seedType) {
    }
}

