/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.AsyncExecutor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpongeWithLavaModule
implements Listener {
    private static final int RADIUS = 3;
    private static final int MAX_LAVA_BLOCKS = 64;
    private static final double MAX_DISTANCE = 9.0;
    private final JavaPlugin plugin;

    public SpongeWithLavaModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpongePlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.SPONGE) {
            return;
        }
        if (!event.canBuild()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.sponge_with_lava") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.sponge_with_lava")) {
            return;
        }
        AsyncExecutor.getExecutor().execute(() -> this.processLavaAbsorption(block));
    }

    private void processLavaAbsorption(Block sponge) {
        int[] absorbed = new int[]{0};
        for (int x = -3; x <= 3 && absorbed[0] < 64; ++x) {
            for (int y = -3; y <= 3 && absorbed[0] < 64; ++y) {
                for (int z = -3; z <= 3 && absorbed[0] < 64; ++z) {
                    if ((double)(x * x + y * y + z * z) > 9.0) continue;
                    int fx = x;
                    int fy = y;
                    int fz = z;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        Block target = sponge.getRelative(fx, fy, fz);
                        if (target.getType() == Material.LAVA) {
                            target.setType(Material.AIR);
                            absorbed[0] = absorbed[0] + 1;
                            if (absorbed[0] == 1 && sponge.getType() == Material.SPONGE) {
                                sponge.setType(Material.WET_SPONGE);
                            }
                        }
                    });
                }
            }
        }
    }
}

