/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class TotemFromInventoryModule
implements Listener {
    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.hasPermission("vitamin.module.totem_from_inventory") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.totem_from_inventory")) {
            return;
        }
        double finalHealth = player.getHealth() - event.getFinalDamage();
        if (finalHealth <= 0.0 && this.hasTotemAnywhere(player)) {
            this.removeOneTotem(player);
            event.setCancelled(true);
            player.setHealth(1.0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 800, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0));
            player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation().add(0.0, 1.0, 0.0), 100);
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
        }
    }

    private boolean hasTotemAnywhere(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack stack : inventory.getContents()) {
            if (stack == null || stack.getType() != Material.TOTEM_OF_UNDYING) continue;
            return true;
        }
        for (ItemStack armor : inventory.getArmorContents()) {
            if (armor == null || armor.getType() != Material.TOTEM_OF_UNDYING) continue;
            return true;
        }
        ItemStack offHand = inventory.getItemInOffHand();
        return offHand.getType() == Material.TOTEM_OF_UNDYING;
    }

    private void removeOneTotem(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack == null || stack.getType() != Material.TOTEM_OF_UNDYING) continue;
            this.decrementStack(inventory, i, stack);
            return;
        }
        ItemStack[] armorContents = inventory.getArmorContents();
        for (int i = 0; i < armorContents.length; ++i) {
            ItemStack armor = armorContents[i];
            if (armor == null || armor.getType() != Material.TOTEM_OF_UNDYING) continue;
            this.decrementStack(armorContents, i, armor);
            inventory.setArmorContents(armorContents);
            return;
        }
        ItemStack offHand = inventory.getItemInOffHand();
        if (!offHand.getType().isAir() && offHand.getType() == Material.TOTEM_OF_UNDYING) {
            if (offHand.getAmount() > 1) {
                offHand.setAmount(offHand.getAmount() - 1);
            } else {
                inventory.setItemInOffHand(null);
            }
        }
    }

    private void decrementStack(ItemStack[] stacks, int index, ItemStack stack) {
        int amount = stack.getAmount();
        if (amount > 1) {
            stack.setAmount(amount - 1);
        } else {
            stacks[index] = null;
        }
    }

    private void decrementStack(PlayerInventory inventory, int index, ItemStack stack) {
        int amount = stack.getAmount();
        if (amount > 1) {
            stack.setAmount(amount - 1);
        } else {
            inventory.setItem(index, null);
        }
    }
}

