/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.modules.core.LeafDecayModule;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VeinLogModule
implements Listener {
    private static final int MAX_BLOCKS = 100;
    private static final Set<Material> LOGS = EnumSet.of(Material.OAK_LOG, new Material[]{Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM});
    private final JavaPlugin plugin;

    public VeinLogModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.tree_vein_miner") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.tree_vein_miner")) {
            return;
        }
        Block block = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.isValidMining(block.getType(), tool.getType())) {
            return;
        }
        if (!tool.containsEnchantment(Enchantment.EFFICIENCY) || tool.getEnchantmentLevel(Enchantment.EFFICIENCY) != 5) {
            return;
        }
        this.processVeinMining(block);
    }

    private boolean isValidMining(Material blockType, Material toolType) {
        return this.isLog(blockType) && this.isAxe(toolType);
    }

    private boolean isLog(Material material) {
        return LOGS.contains(material);
    }

    private boolean isAxe(Material material) {
        return material.name().endsWith("_AXE");
    }

    private void processVeinMining(Block startBlock) {
        LeafDecayModule decayModule;
        HashSet<Block> veinBlocks = new HashSet<Block>();
        this.findConnectedLogs(startBlock, startBlock.getType(), veinBlocks);
        if (veinBlocks.size() > 100) {
            return;
        }
        for (Block logBlock : veinBlocks) {
            Material dropMaterial = logBlock.getType();
            logBlock.setType(Material.AIR, true);
            logBlock.getWorld().dropItemNaturally(logBlock.getLocation(), new ItemStack(dropMaterial));
            for (Block neighbor : this.getAdjacentBlocks(logBlock)) {
                neighbor.getState().update(true, true);
            }
        }
        if (LeafDecayModule.ENABLED && (decayModule = LeafDecayModule.getInstance()) != null) {
            for (Block logBlock : veinBlocks) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        decayModule.removeConnectedLeaves(logBlock.getWorld(), logBlock);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    private void findConnectedLogs(Block block, Material logType, Set<Block> visited) {
        if (visited.size() >= 100 || visited.contains(block)) {
            return;
        }
        visited.add(block);
        for (Block neighbor : this.getAdjacentBlocks(block)) {
            if (neighbor.getType() != logType) continue;
            this.findConnectedLogs(neighbor, logType, visited);
        }
    }

    private Set<Block> getAdjacentBlocks(Block block) {
        int[][] offsets;
        HashSet<Block> neighbors = new HashSet<Block>();
        for (int[] offset : offsets = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            neighbors.add(block.getRelative(offset[0], offset[1], offset[2]));
        }
        return neighbors;
    }
}

