/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class VeinMinerModule
implements Listener {
    private static final int MAX_BLOCKS = 64;
    private static final Set<Material> ORES = EnumSet.noneOf(Material.class);
    private static final Map<Material, Material> RAW_TO_INGOT = new EnumMap<Material, Material>(Material.class);

    public VeinMinerModule(JavaPlugin ignored) {
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.vein_miner") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.vein_miner")) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        if (!this.isValidMining(block.getType(), tool.getType())) {
            return;
        }
        if (!tool.containsEnchantment(Enchantment.EFFICIENCY) || tool.getEnchantmentLevel(Enchantment.EFFICIENCY) != 5) {
            return;
        }
        event.setCancelled(true);
        this.processVeinMining(block, tool);
    }

    private void processVeinMining(Block block, ItemStack tool) {
        HashSet<Block> veinBlocks = new HashSet<Block>();
        this.findConnectedOres(block, block.getType(), veinBlocks);
        if (veinBlocks.size() > 64) {
            return;
        }
        for (Block ore : veinBlocks) {
            this.handleBlockDrop(ore, tool);
        }
    }

    private void handleBlockDrop(Block ore, ItemStack tool) {
        List<ItemStack> drops;
        boolean hasSilkTouch = tool.containsEnchantment(Enchantment.SILK_TOUCH);
        boolean hasFireAspect = tool.containsEnchantment(Enchantment.FIRE_ASPECT);
        if (hasSilkTouch) {
            drops = Collections.singletonList(new ItemStack(ore.getType()));
        } else {
            drops = ore.getDrops(tool);
            if (hasFireAspect) {
                ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
                for (ItemStack drop : drops) {
                    Material dropType = drop.getType();
                    if (RAW_TO_INGOT.containsKey(dropType)) {
                        Material ingot = RAW_TO_INGOT.get(dropType);
                        modifiedDrops.add(new ItemStack(ingot, drop.getAmount()));
                        continue;
                    }
                    modifiedDrops.add(drop);
                }
                drops = modifiedDrops;
            }
        }
        ore.setType(Material.AIR);
        for (ItemStack drop : drops) {
            ore.getWorld().dropItemNaturally(ore.getLocation(), drop);
        }
    }

    private void findConnectedOres(Block block, Material oreType, Set<Block> visited) {
        if (visited.size() >= 64 || visited.contains(block)) {
            return;
        }
        visited.add(block);
        for (Block neighbor : this.getAdjacentBlocks(block)) {
            if (neighbor.getType() != oreType) continue;
            this.findConnectedOres(neighbor, oreType, visited);
        }
    }

    private Set<Block> getAdjacentBlocks(Block block) {
        int[][] offsets;
        HashSet<Block> neighbors = new HashSet<Block>();
        for (int[] offset : offsets = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            neighbors.add(block.getRelative(offset[0], offset[1], offset[2]));
        }
        return neighbors;
    }

    private boolean isValidMining(Material blockType, Material toolType) {
        return this.isOre(blockType) && this.isPickaxe(toolType);
    }

    private boolean isOre(Material material) {
        return ORES.contains(material);
    }

    private boolean isPickaxe(Material material) {
        return material.name().endsWith("_PICKAXE");
    }

    static {
        ORES.add(Material.COAL_ORE);
        ORES.add(Material.DEEPSLATE_COAL_ORE);
        ORES.add(Material.IRON_ORE);
        ORES.add(Material.DEEPSLATE_IRON_ORE);
        ORES.add(Material.GOLD_ORE);
        ORES.add(Material.DEEPSLATE_GOLD_ORE);
        ORES.add(Material.COPPER_ORE);
        ORES.add(Material.DEEPSLATE_COPPER_ORE);
        ORES.add(Material.LAPIS_ORE);
        ORES.add(Material.DEEPSLATE_LAPIS_ORE);
        ORES.add(Material.REDSTONE_ORE);
        ORES.add(Material.DEEPSLATE_REDSTONE_ORE);
        ORES.add(Material.EMERALD_ORE);
        ORES.add(Material.DEEPSLATE_EMERALD_ORE);
        ORES.add(Material.DIAMOND_ORE);
        ORES.add(Material.DEEPSLATE_DIAMOND_ORE);
        ORES.add(Material.NETHER_QUARTZ_ORE);
        ORES.add(Material.NETHER_GOLD_ORE);
        RAW_TO_INGOT.put(Material.RAW_IRON, Material.IRON_INGOT);
        RAW_TO_INGOT.put(Material.RAW_GOLD, Material.GOLD_INGOT);
        RAW_TO_INGOT.put(Material.RAW_COPPER, Material.COPPER_INGOT);
    }
}

