/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class VillagerTauntModule
implements Listener {
    private final Set<Player> playersHoldingEmerald = new HashSet<Player>();
    private final JavaPlugin plugin;
    private final double MOVEMENT_SPEED = 1.0;
    private final Map<Player, Set<Villager>> villagerTasks = new WeakHashMap<Player, Set<Villager>>();
    private final Map<Item, Set<Villager>> droppedEmeraldTasks = new WeakHashMap<Item, Set<Villager>>();
    private final Map<Villager, BukkitRunnable> villagerRunnables = new HashMap<Villager, BukkitRunnable>();
    private final double DETECTION_RADIUS_SQUARED = 400.0;
    private final double MINIMUM_DISTANCE = 1.5;
    private final Map<UUID, Long> effectCooldowns = new HashMap<UUID, Long>();
    private final long COOLDOWN_TIME = 5000L;
    private final Map<UUID, Boolean> moduleEnabledCache = new HashMap<UUID, Boolean>();
    private final Map<Villager, Location> lastPositions = new HashMap<Villager, Location>();
    private final int STUCK_THRESHOLD = 10;

    public VillagerTauntModule(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getOnlinePlayers().forEach(player -> this.moduleEnabledCache.put(player.getUniqueId(), DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_follow_emeralds")));
        this.startDroppedEmeraldCheck();
    }

    private void startDroppedEmeraldCheck() {
        new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    for (Item entity : world.getEntitiesByClass(Item.class)) {
                        if (entity.getItemStack().getType() != Material.EMERALD) continue;
                        VillagerTauntModule.this.updateVillagerMovementForDroppedEmerald(entity);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        Item item = event.getEntity();
        if (item.getItemStack().getType() == Material.EMERALD) {
            this.updateVillagerMovementForDroppedEmerald(item);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.moduleEnabledCache.put(player.getUniqueId(), DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_follow_emeralds"));
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        this.checkPlayerInventory(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerInventory(player), 1L);
        }
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        this.checkPlayerInventory(player);
    }

    private void checkPlayerInventory(Player player) {
        if (this.isEligible(player)) {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand.getType() == Material.EMERALD || offHand.getType() == Material.EMERALD) {
            if (!this.playersHoldingEmerald.contains(player)) {
                this.playersHoldingEmerald.add(player);
                this.playEmeraldEffect(player);
            }
        } else {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.isEligible(player) || !this.playersHoldingEmerald.contains(player)) {
            this.stopVillagerTasks(player);
            return;
        }
        this.updateVillagerMovement(player);
    }

    private void updateVillagerMovement(Player player) {
        Set currentVillagers = this.villagerTasks.computeIfAbsent(player, k -> new HashSet());
        if (currentVillagers.size() >= 5) {
            return;
        }
        currentVillagers.removeIf(villager -> !villager.isValid() || villager.isDead());
        HashSet<Villager> nearbyVillagers = new HashSet<Villager>();
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 20.0, 10.0, 20.0)) {
            if (entity.getType() != EntityType.VILLAGER) continue;
            nearbyVillagers.add((Villager)entity);
        }
        for (Villager villager2 : nearbyVillagers) {
            if (currentVillagers.contains(villager2) || this.isVillagerAssigned(villager2)) continue;
            currentVillagers.add(villager2);
            this.startVillagerMovement(player, villager2);
        }
        currentVillagers.removeIf(villager -> !nearbyVillagers.contains(villager));
    }

    private void updateVillagerMovementForDroppedEmerald(Item item) {
        Set currentVillagers = this.droppedEmeraldTasks.computeIfAbsent(item, k -> new HashSet());
        if (currentVillagers.size() >= 5) {
            return;
        }
        currentVillagers.removeIf(villager -> !villager.isValid() || villager.isDead());
        HashSet<Villager> nearbyVillagers = new HashSet<Villager>();
        for (Entity entity : item.getWorld().getNearbyEntities(item.getLocation(), 20.0, 10.0, 20.0)) {
            if (entity.getType() != EntityType.VILLAGER) continue;
            nearbyVillagers.add((Villager)entity);
        }
        for (Villager villager2 : nearbyVillagers) {
            if (currentVillagers.contains(villager2) || this.isVillagerAssigned(villager2)) continue;
            Player nearestPlayer = this.getNearestPlayerWithEmerald(villager2);
            if (nearestPlayer != null) {
                double distToPlayer = villager2.getLocation().distanceSquared(nearestPlayer.getLocation());
                double distToItem = villager2.getLocation().distanceSquared(item.getLocation());
                if (!(distToItem < distToPlayer)) continue;
                currentVillagers.add(villager2);
                this.startVillagerMovementForDroppedEmerald(item, villager2);
                continue;
            }
            currentVillagers.add(villager2);
            this.startVillagerMovementForDroppedEmerald(item, villager2);
        }
        currentVillagers.removeIf(villager -> !nearbyVillagers.contains(villager));
        if (currentVillagers.isEmpty()) {
            this.droppedEmeraldTasks.remove(item);
        }
    }

    private boolean isVillagerAssigned(Villager villager) {
        for (Set<Villager> villagers : this.villagerTasks.values()) {
            if (!villagers.contains(villager)) continue;
            return true;
        }
        for (Set<Villager> villagers : this.droppedEmeraldTasks.values()) {
            if (!villagers.contains(villager)) continue;
            return true;
        }
        return false;
    }

    private Player getNearestPlayerWithEmerald(Villager villager) {
        Player nearest = null;
        double minDist = Double.MAX_VALUE;
        for (Player player : this.playersHoldingEmerald) {
            double dist;
            if (player.getWorld() != villager.getWorld() || !((dist = player.getLocation().distanceSquared(villager.getLocation())) < minDist)) continue;
            minDist = dist;
            nearest = player;
        }
        return nearest;
    }

    private void startVillagerMovement(final Player player, final Villager villager) {
        this.stopVillagerMovement(villager);
        BukkitRunnable runnable = new BukkitRunnable(){
            int stuckCounter = 0;

            public void run() {
                if (!player.isOnline() || !villager.isValid() || villager.isDead() || !VillagerTauntModule.this.playersHoldingEmerald.contains(player) || player.getWorld() != villager.getWorld() || player.getLocation().distanceSquared(villager.getLocation()) > 400.0) {
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    this.cancel();
                    VillagerTauntModule.this.villagerRunnables.remove(villager);
                    return;
                }
                Location currentLoc = villager.getLocation();
                if (VillagerTauntModule.this.lastPositions.containsKey(villager) && VillagerTauntModule.this.lastPositions.get(villager).equals((Object)currentLoc)) {
                    ++this.stuckCounter;
                    if (this.stuckCounter >= 10) {
                        double jumpHeight = 0.3 + Math.random() * 0.2;
                        villager.setVelocity(new Vector(0.0, jumpHeight, 0.0));
                        this.stuckCounter = 0;
                    }
                } else {
                    this.stuckCounter = 0;
                }
                VillagerTauntModule.this.lastPositions.put(villager, currentLoc);
                double distanceSquared = player.getLocation().distanceSquared(villager.getLocation());
                if (distanceSquared <= 2.25) {
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    VillagerTauntModule.this.facePlayer(villager, player);
                    return;
                }
                Vector direction = player.getLocation().toVector().subtract(villager.getLocation().toVector()).normalize().multiply(0.2);
                villager.setVelocity(new Vector(direction.getX(), villager.getVelocity().getY(), direction.getZ()));
                VillagerTauntModule.this.facePlayer(villager, player);
            }
        };
        runnable.runTaskTimer((Plugin)this.plugin, 0L, 5L);
        this.villagerRunnables.put(villager, runnable);
    }

    private void startVillagerMovementForDroppedEmerald(final Item item, final Villager villager) {
        this.stopVillagerMovement(villager);
        BukkitRunnable runnable = new BukkitRunnable(){
            int stuckCounter = 0;

            public void run() {
                if (!item.isValid() || item.isDead() || !villager.isValid() || villager.isDead() || item.getWorld() != villager.getWorld() || item.getLocation().distanceSquared(villager.getLocation()) > 400.0) {
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    this.cancel();
                    VillagerTauntModule.this.villagerRunnables.remove(villager);
                    return;
                }
                Location currentLoc = villager.getLocation();
                if (VillagerTauntModule.this.lastPositions.containsKey(villager) && VillagerTauntModule.this.lastPositions.get(villager).equals((Object)currentLoc)) {
                    ++this.stuckCounter;
                    if (this.stuckCounter >= 10) {
                        double jumpHeight = 0.3 + Math.random() * 0.2;
                        villager.setVelocity(new Vector(0.0, jumpHeight, 0.0));
                        this.stuckCounter = 0;
                    }
                } else {
                    this.stuckCounter = 0;
                }
                VillagerTauntModule.this.lastPositions.put(villager, currentLoc);
                double distanceSquared = item.getLocation().distanceSquared(villager.getLocation());
                if (distanceSquared <= 2.25) {
                    VillagerTauntModule.this.pickUpEmerald(villager, item);
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    this.cancel();
                    VillagerTauntModule.this.villagerRunnables.remove(villager);
                    return;
                }
                Vector direction = item.getLocation().toVector().subtract(villager.getLocation().toVector()).normalize().multiply(0.2);
                villager.setVelocity(new Vector(direction.getX(), villager.getVelocity().getY(), direction.getZ()));
                VillagerTauntModule.this.faceLocation(villager, item.getLocation());
            }
        };
        runnable.runTaskTimer((Plugin)this.plugin, 0L, 5L);
        this.villagerRunnables.put(villager, runnable);
    }

    private void pickUpEmerald(Villager villager, Item item) {
        ItemStack itemStack = item.getItemStack();
        villager.getInventory().addItem(new ItemStack[]{itemStack});
        item.remove();
        this.droppedEmeraldTasks.remove(item);
        villager.getWorld().playSound(villager.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.0f);
    }

    private void stopVillagerTasks(Player player) {
        Set<Villager> villagers = this.villagerTasks.remove(player);
        if (villagers != null) {
            for (Villager villager : villagers) {
                this.stopVillagerMovement(villager);
            }
        }
    }

    private void stopVillagerMovement(Villager villager) {
        if (this.villagerRunnables.containsKey(villager)) {
            this.villagerRunnables.get(villager).cancel();
            this.villagerRunnables.remove(villager);
            villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
        }
    }

    private void playEmeraldEffect(Player player) {
        long currentTime = System.currentTimeMillis();
        if (!this.effectCooldowns.containsKey(player.getUniqueId()) || currentTime - this.effectCooldowns.get(player.getUniqueId()) > 5000L) {
            player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
            this.effectCooldowns.put(player.getUniqueId(), currentTime);
        }
    }

    private void facePlayer(Villager villager, Player player) {
        this.faceLocation(villager, player.getLocation());
    }

    private void faceLocation(Villager villager, Location target) {
        Location villagerLoc = villager.getLocation();
        double dx = target.getX() - villagerLoc.getX();
        double dz = target.getZ() - villagerLoc.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        villager.setRotation(yaw, villagerLoc.getPitch());
    }

    private boolean isEligible(Player player) {
        return !player.hasPermission("vitamin.module.villager_follow_emeralds") || this.moduleEnabledCache.getOrDefault(player.getUniqueId(), false) == false;
    }
}

