/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.paper;

import com.destroystokyo.paper.entity.Pathfinder;
import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PaperVillagerTauntModule
implements Listener {
    private final Set<Player> playersHoldingEmerald = new HashSet<Player>();
    private final JavaPlugin plugin;
    private final double MOVEMENT_SPEED = 0.8;
    private final Map<Villager, Entity> villagerTargets = new HashMap<Villager, Entity>();
    private final double PICKUP_DISTANCE = 1.5;
    private final double DETECTION_RADIUS = 10.0;
    private final double DETECTION_HEIGHT = 5.0;

    public PaperVillagerTauntModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.startVillagerPathfindingUpdate();
        this.startVillagerPickupCheck();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        this.checkPlayerInventory(player);
        this.updateVillagerAssignments(player.getWorld());
    }

    private void checkPlayerInventory(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand.getType() == Material.EMERALD || offHand.getType() == Material.EMERALD) {
            if (!this.playersHoldingEmerald.contains(player)) {
                this.playersHoldingEmerald.add(player);
                this.playEmeraldEffect(player);
            }
        } else {
            this.playersHoldingEmerald.remove(player);
        }
    }

    private void startVillagerPathfindingUpdate() {
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<Villager, Entity> entry : PaperVillagerTauntModule.this.villagerTargets.entrySet()) {
                    Villager villager = entry.getKey();
                    Entity target = entry.getValue();
                    if (target == null || !target.isValid()) {
                        PaperVillagerTauntModule.this.villagerTargets.remove(villager);
                        continue;
                    }
                    Pathfinder pathfinder = villager.getPathfinder();
                    if (target instanceof Player) {
                        pathfinder.moveTo((LivingEntity)((Player)target), 0.8);
                        continue;
                    }
                    if (!(target instanceof Item)) continue;
                    pathfinder.moveTo(target.getLocation(), 0.8);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void startVillagerPickupCheck() {
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<Villager, Entity>> iterator = PaperVillagerTauntModule.this.villagerTargets.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Villager, Entity> entry = iterator.next();
                    Villager villager = entry.getKey();
                    Entity target = entry.getValue();
                    if (!(target instanceof Item)) continue;
                    Item item = (Item)target;
                    if (!(villager.getLocation().distanceSquared(item.getLocation()) < 2.25)) continue;
                    PaperVillagerTauntModule.this.pickUpEmerald(villager, item);
                    iterator.remove();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    private void updateVillagerAssignments(World world) {
        for (Villager entity : world.getEntitiesByClass(Villager.class)) {
            this.assignVillagerToNearestTarget(entity);
        }
    }

    private void assignVillagerToNearestTarget(Villager villager) {
        Player nearestTarget = null;
        double minDistanceSquared = Double.MAX_VALUE;
        for (Player player : this.playersHoldingEmerald) {
            double distanceSquared;
            if (player.getWorld() != villager.getWorld() || !player.hasPermission("vitamin.module.villager_follow_emeralds") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_follow_emeralds") || !((distanceSquared = player.getLocation().distanceSquared(villager.getLocation())) < minDistanceSquared) || !(distanceSquared < 100.0)) continue;
            minDistanceSquared = distanceSquared;
            nearestTarget = player;
        }
        for (Entity entity : villager.getWorld().getNearbyEntities(villager.getLocation(), 10.0, 5.0, 10.0)) {
            double distanceSquared;
            Item item;
            if (!(entity instanceof Item) || (item = (Item)entity).getItemStack().getType() != Material.EMERALD) continue;
            boolean hasEligiblePlayerNearby = false;
            for (Player player : this.playersHoldingEmerald) {
                if (player.getWorld() != item.getWorld() || !(player.getLocation().distanceSquared(item.getLocation()) < 100.0) || !player.hasPermission("vitamin.module.villager_follow_emeralds") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_follow_emeralds")) continue;
                hasEligiblePlayerNearby = true;
                break;
            }
            if (!hasEligiblePlayerNearby || !((distanceSquared = item.getLocation().distanceSquared(villager.getLocation())) < minDistanceSquared)) continue;
            minDistanceSquared = distanceSquared;
            nearestTarget = item;
        }
        if (nearestTarget != null) {
            this.villagerTargets.put(villager, (Entity)nearestTarget);
        } else {
            this.villagerTargets.remove(villager);
        }
    }

    private void pickUpEmerald(Villager villager, Item item) {
        ItemStack itemStack = item.getItemStack();
        villager.getInventory().addItem(new ItemStack[]{itemStack});
        item.remove();
        villager.getWorld().playSound(villager.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.0f);
    }

    private void playEmeraldEffect(Player player) {
        player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
    }
}

