/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin;

import com.soystargaze.vitamin.adapter.VersionAdapter;
import com.soystargaze.vitamin.adapter.VersionAdapter_1_21_1;
import com.soystargaze.vitamin.adapter.VersionAdapter_1_21_4;
import com.soystargaze.vitamin.commands.VitaminCommandManager;
import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.shaded.bstats.bukkit.Metrics;
import com.soystargaze.vitamin.utils.AsyncExecutor;
import com.soystargaze.vitamin.utils.ConsoleUtils;
import com.soystargaze.vitamin.utils.LoggingUtils;
import com.soystargaze.vitamin.utils.TranslationHandler;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Vitamin
extends JavaPlugin
implements Listener {
    private static Vitamin instance;
    private ModuleManager moduleManager;
    private VitaminCommandManager commandManager;
    private VersionAdapter versionAdapter;
    private static final int BSTATS_PLUGIN_ID = 24855;

    public void onEnable() {
        instance = this;
        try {
            this.setupVersionAdapter();
            this.initializePlugin();
        }
        catch (Exception e) {
            String LOCAL_TEST_MESSAGE_KEY = "plugin.enable_error";
            TranslationHandler.registerTemporaryTranslation("plugin.enable_error", "Plugin cannot be enabled: {0}");
            LoggingUtils.logTranslated("plugin.enable_error", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        AsyncExecutor.shutdown();
        LoggingUtils.logTranslated("plugin.disabled", new Object[0]);
        instance = null;
        DatabaseHandler.close();
    }

    private void initializePlugin() {
        try {
            this.loadConfigurations();
            DatabaseHandler.initialize(this);
            LoggingUtils.logTranslated("plugin.separator", new Object[0]);
            this.moduleManager = new ModuleManager(this);
            LoggingUtils.logTranslated("plugin.separator", new Object[0]);
            this.initializeMetrics();
        }
        catch (Exception e) {
            LoggingUtils.logTranslated("plugin.enable_error", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void loadConfigurations() {
        ConfigHandler.setup(this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.setupTranslations();
        TranslationHandler.loadTranslations(this, ConfigHandler.getLanguage());
        ConsoleUtils.displayAsciiArt(this);
        AsyncExecutor.initialize();
        this.initializeCommandManager();
        ConsoleUtils.displaySuccessMessage(this);
    }

    private void setupTranslations() {
        String configuredLanguage;
        String[] defaultLanguages;
        File translationsFolder = new File(this.getDataFolder(), "Translations");
        if (!translationsFolder.exists() && !translationsFolder.mkdirs()) {
            LoggingUtils.logTranslated("translations.folder_error", new Object[0]);
            return;
        }
        for (String languageFile : defaultLanguages = new String[]{"en_us.yml", "es_es.yml", "fr_fr.yml", "de_de.yml", "pt_br.yml", "pl_pl.yml", "zh_cn.yml", "ko_kr.yml", "tr_tr.yml"}) {
            this.saveDefaultTranslation(languageFile);
        }
        File[] translationFiles = translationsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (translationFiles != null) {
            for (File file : translationFiles) {
                String language = file.getName().replace(".yml", "");
                TranslationHandler.loadTranslations(this, language);
            }
        }
        if (TranslationHandler.isLanguageAvailable(configuredLanguage = ConfigHandler.getLanguage())) {
            TranslationHandler.setActiveLanguage(configuredLanguage);
        } else {
            String LANG_NOT_FOUND_KEY = "translations.language_not_found";
            TranslationHandler.registerTemporaryTranslation("translations.language_not_found", "Language not found: {0}");
            LoggingUtils.logTranslated("translations.language_not_found", configuredLanguage);
        }
    }

    private void saveDefaultTranslation(String fileName) {
        File translationFile = new File(this.getDataFolder(), "Translations/" + fileName);
        if (!translationFile.exists()) {
            try {
                this.saveResource("Translations/" + fileName, false);
            }
            catch (Exception e) {
                String LANG_NOT_SAVED_KEY = "translations.save_error";
                TranslationHandler.registerTemporaryTranslation("translations.save_error", "Language cannot be saved: {0}");
                LoggingUtils.logTranslated("translations.save_error", fileName);
            }
        }
    }

    private void initializeCommandManager() {
        try {
            if (this.commandManager == null) {
                this.commandManager = new VitaminCommandManager(this);
                this.commandManager.registerCommands();
            }
        }
        catch (Exception e) {
            LoggingUtils.logTranslated("command.register_error", e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeMetrics() {
        try {
            new Metrics(this, 24855);
        }
        catch (Exception e) {
            String BSTATS_ERROR = "bstats.error";
            TranslationHandler.registerTemporaryTranslation("bstats.error", "BStats error: {0}");
            LoggingUtils.logTranslated("bstats.error", e.getMessage());
        }
    }

    private void setupVersionAdapter() {
        String raw = Bukkit.getBukkitVersion();
        String version = raw.replaceFirst(".*?(\\d+\\.\\d+\\.\\d+).*", "$1");
        String[] parts = version.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = Integer.parseInt(parts[2]);
        this.versionAdapter = major == 1 && minor == 21 && patch >= 3 ? new VersionAdapter_1_21_4() : new VersionAdapter_1_21_1();
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }

    public static Vitamin getInstance() {
        return instance;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }
}

