/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.modules.core.CustomRecipesModule;
import com.soystargaze.vitamin.utils.TranslationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class ModuleCommand
implements CommandExecutor,
TabCompleter {
    private final Vitamin plugin;
    private final ModuleManager moduleManager;

    public ModuleCommand(Vitamin plugin) {
        this.plugin = plugin;
        this.moduleManager = plugin.getModuleManager();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        Listener moduleInstance;
        Object key;
        boolean enable;
        if (!sender.hasPermission("vitamin.module")) {
            this.sendTranslatedMessage(sender, "commands.module.no_permission", new Object[0]);
            return true;
        }
        if (args.length != 2) {
            this.sendTranslatedMessage(sender, "commands.module.usage", new Object[0]);
            return true;
        }
        String moduleName = args[0];
        String stateArg = args[1];
        if (stateArg.equalsIgnoreCase("enable")) {
            enable = true;
        } else if (stateArg.equalsIgnoreCase("disable")) {
            enable = false;
        } else {
            this.sendTranslatedMessage(sender, "commands.module.usage", new Object[0]);
            return true;
        }
        Object object = key = moduleName.startsWith("module.") ? moduleName : "module." + moduleName;
        if (!this.plugin.getConfig().contains((String)key)) {
            this.sendTranslatedMessage(sender, "commands.module.not_found", key);
            return true;
        }
        this.plugin.getConfig().set((String)key, (Object)enable);
        this.plugin.saveConfig();
        if (((String)key).equalsIgnoreCase("module.custom_recipes") && !enable && (moduleInstance = this.moduleManager.getModule("custom_recipes")) instanceof CustomRecipesModule) {
            ((CustomRecipesModule)moduleInstance).unregisterRecipes();
        }
        this.moduleManager.reloadModules();
        this.sendTranslatedMessage(sender, "commands.module.changed", key, enable ? "enabled" : "disabled");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            if (this.plugin.getConfig().contains("module")) {
                Set keys = Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("module")).getKeys(false);
                for (String key : keys) {
                    suggestions.add("module." + key);
                }
            } else {
                Set keys = this.plugin.getConfig().getKeys(false);
                for (String key : keys) {
                    if (!key.startsWith("module.")) continue;
                    suggestions.add(key);
                }
            }
        } else if (args.length == 2) {
            suggestions.add("enable");
            suggestions.add("disable");
        }
        return suggestions;
    }

    private void sendTranslatedMessage(CommandSender sender, String key, Object ... args) {
        Component messageComponent = TranslationHandler.getPlayerMessage(key, args);
        String message = LegacyComponentSerializer.legacyAmpersand().serialize(messageComponent);
        String formattedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        sender.sendMessage(formattedMessage);
    }
}

