/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.modules.core.CustomRecipesModule;
import com.soystargaze.vitamin.utils.LoggingUtils;
import com.soystargaze.vitamin.utils.TranslationHandler;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
implements CommandExecutor,
TabCompleter {
    private final Vitamin plugin;

    public ReloadCommand(Vitamin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.hasPermission("vitamin.reload")) {
            this.sendTranslatedMessage(sender, "commands.reload.no_permission", new Object[0]);
            return true;
        }
        try {
            Listener mod;
            this.plugin.reloadConfig();
            ConfigHandler.reload();
            ModuleManager moduleManager = this.plugin.getModuleManager();
            boolean customEnabled = this.plugin.getConfig().getBoolean("module.custom_recipes", true);
            if (!customEnabled && (mod = moduleManager.getModule("custom_recipes")) instanceof CustomRecipesModule) {
                ((CustomRecipesModule)mod).unregisterRecipes();
            }
            moduleManager.reloadModules();
            int loadedTranslations = this.reloadTranslations();
            this.sendTranslatedMessage(sender, "commands.reload.success", loadedTranslations);
        }
        catch (Exception e) {
            this.sendTranslatedMessage(sender, "commands.reload.error", new Object[0]);
            LoggingUtils.logTranslated("commands.reload.error", e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        return new ArrayList<String>();
    }

    private int reloadTranslations() {
        TranslationHandler.clearTranslations();
        TranslationHandler.loadTranslations(this.plugin, this.plugin.getConfig().getString("language", "en_us"));
        return TranslationHandler.getLoadedTranslationsCount();
    }

    private void sendTranslatedMessage(CommandSender sender, String key, Object ... args) {
        Component messageComponent = TranslationHandler.getPlayerMessage(key, args);
        String message = LegacyComponentSerializer.legacyAmpersand().serialize(messageComponent);
        String formattedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        sender.sendMessage(formattedMessage);
    }
}

