/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.commands.ModuleCommand;
import com.soystargaze.vitamin.commands.PModuleCommand;
import com.soystargaze.vitamin.commands.ReloadCommand;
import com.soystargaze.vitamin.utils.TranslationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class VitaminCommand
implements CommandExecutor,
TabCompleter {
    private final ModuleCommand moduleCommand;
    private final PModuleCommand pModuleCommand;
    private final ReloadCommand reloadCommand;

    public VitaminCommand(Vitamin plugin) {
        this.moduleCommand = new ModuleCommand(plugin);
        this.pModuleCommand = new PModuleCommand(plugin);
        this.reloadCommand = new ReloadCommand(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.hasPermission("vitamin.use")) {
            this.sendTranslatedMessage(sender, "commands.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendTranslatedMessage(sender, "commands.usage", new Object[0]);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        return switch (subCommand) {
            case "reload" -> this.reloadCommand.onCommand(sender, command, label, subArgs);
            case "module" -> this.moduleCommand.onCommand(sender, command, label, subArgs);
            case "pmodule" -> this.pModuleCommand.onCommand(sender, command, label, subArgs);
            default -> {
                this.sendTranslatedMessage(sender, "commands.usage", new Object[0]);
                yield true;
            }
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (sender.hasPermission("vitamin.reload")) {
                subCommands.add("reload");
            }
            if (sender.hasPermission("vitamin.module")) {
                subCommands.add("module");
            }
            if (sender.hasPermission("vitamin.pmodule")) {
                subCommands.add("pmodule");
            }
            return subCommands;
        }
        if (args.length > 1) {
            String subCommand = args[0].toLowerCase();
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return switch (subCommand) {
                case "reload" -> this.reloadCommand.onTabComplete(sender, command, alias, subArgs);
                case "module" -> this.moduleCommand.onTabComplete(sender, command, alias, subArgs);
                case "pmodule" -> this.pModuleCommand.onTabComplete(sender, command, alias, subArgs);
                default -> new ArrayList<String>();
            };
        }
        return new ArrayList<String>();
    }

    private void sendTranslatedMessage(CommandSender sender, String key, Object ... args) {
        Component messageComponent = TranslationHandler.getPlayerMessage(key, args);
        String message = LegacyComponentSerializer.legacyAmpersand().serialize(messageComponent);
        String formattedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        sender.sendMessage(formattedMessage);
    }
}

