/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.Map;
import net.advancedplugins.ae.api.AEAPI;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class EnchantsBackModule
implements Listener {
    private final JavaPlugin plugin;

    public EnchantsBackModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onGrindstoneUse(InventoryClickEvent event) {
        boolean hasAE;
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof GrindstoneInventory)) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!player.hasPermission("vitamin.module.enchants_back") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.enchants_back")) {
            return;
        }
        ItemStack inputItem = inventory.getItem(0);
        if (inputItem == null) {
            return;
        }
        Map vanillaEnchants = inputItem.getEnchantments();
        boolean hasVanilla = !vanillaEnchants.isEmpty();
        boolean aeLoaded = this.plugin.getServer().getPluginManager().isPluginEnabled("AdvancedEnchantments");
        HashMap aeEnchants = aeLoaded ? AEAPI.getEnchantmentsOnItem((ItemStack)inputItem) : Map.of();
        boolean bl = hasAE = !aeEnchants.isEmpty();
        if (!hasVanilla && !hasAE) {
            return;
        }
        int totalEnchants = (hasVanilla ? vanillaEnchants.size() : 0) + (hasAE ? aeEnchants.size() : 0);
        int maxReturned = this.plugin.getConfig().getInt("enchants_back.max_returned", totalEnchants);
        int toProcess = Math.min(totalEnchants, maxReturned);
        int bookCount = this.countBooks((Inventory)player.getInventory());
        if (bookCount < toProcess) {
            return;
        }
        int freeSlots = this.getFreeInventorySlots((Inventory)player.getInventory());
        if (freeSlots < toProcess) {
            return;
        }
        int processed = 0;
        for (Map.Entry entry : vanillaEnchants.entrySet()) {
            if (processed >= toProcess) break;
            if (this.createEnchantedBook(player, (Enchantment)entry.getKey(), (Integer)entry.getValue())) {
                this.removeOneBook(player);
                ++processed;
                continue;
            }
            return;
        }
        if (aeLoaded) {
            for (Map.Entry aeEntry : aeEnchants.entrySet()) {
                if (processed >= toProcess) break;
                ItemStack aeBook = new ItemStack(Material.BOOK);
                aeBook = AEAPI.applyEnchant((String)((String)aeEntry.getKey()), (int)((Integer)aeEntry.getValue()), (ItemStack)aeBook);
                if (!player.getInventory().addItem(new ItemStack[]{aeBook}).isEmpty()) continue;
                this.removeOneBook(player);
                ++processed;
            }
        }
        player.updateInventory();
    }

    private boolean createEnchantedBook(Player player, Enchantment ench, int level) {
        try {
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
            if (meta != null) {
                meta.addStoredEnchant(ench, level, true);
                book.setItemMeta((ItemMeta)meta);
                return player.getInventory().addItem(new ItemStack[]{book}).isEmpty();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int countBooks(Inventory inv) {
        int c = 0;
        for (ItemStack itm : inv.getContents()) {
            if (itm == null || itm.getType() != Material.BOOK) continue;
            c += itm.getAmount();
        }
        return c;
    }

    private int getFreeInventorySlots(Inventory inv) {
        int c = 0;
        for (ItemStack itm : inv.getContents()) {
            if (itm != null && itm.getType() != Material.AIR) continue;
            ++c;
        }
        return c;
    }

    private void removeOneBook(Player player) {
        for (ItemStack itm : player.getInventory().getContents()) {
            if (itm == null || itm.getType() != Material.BOOK) continue;
            if (itm.getAmount() > 1) {
                itm.setAmount(itm.getAmount() - 1);
                break;
            }
            player.getInventory().remove(itm);
            break;
        }
    }
}

