/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class VillagerTauntModule
implements Listener {
    private final Set<Player> playersHoldingEmerald = new HashSet<Player>();
    private final JavaPlugin plugin;
    private final double MOVEMENT_SPEED = 0.8;
    private final Map<UUID, Set<Villager>> villagerTasks = new HashMap<UUID, Set<Villager>>();
    private final double DETECTION_RADIUS = 14.0;
    private final double DETECTION_HEIGHT = 7.0;
    private final double MINIMUM_DISTANCE = 1.5;

    public VillagerTauntModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.startInventoryCheck();
    }

    private void startInventoryCheck() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> Bukkit.getOnlinePlayers().forEach(this::checkPlayerInventory), 20L, 20L);
    }

    private void checkPlayerInventory(Player player) {
        if (!player.hasPermission("vitamin.module.villager_taunt") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_taunt")) {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand.getType() == Material.EMERALD || offHand.getType() == Material.EMERALD) {
            if (!this.playersHoldingEmerald.contains(player)) {
                this.playersHoldingEmerald.add(player);
                this.playEmeraldEffect(player);
            }
        } else {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemSwitch(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.villager_taunt") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_taunt")) {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
            return;
        }
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        if (newItem != null && newItem.getType() == Material.EMERALD) {
            this.playersHoldingEmerald.add(player);
            this.playEmeraldEffect(player);
        } else {
            this.stopVillagerTasks(player);
            this.playersHoldingEmerald.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.villager_taunt") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.villager_taunt")) {
            return;
        }
        if (!this.playersHoldingEmerald.contains(player)) {
            this.stopVillagerTasks(player);
            return;
        }
        this.updateVillagerMovement(player);
    }

    private void updateVillagerMovement(Player player) {
        UUID playerId = player.getUniqueId();
        Set currentVillagers = this.villagerTasks.computeIfAbsent(playerId, k -> new HashSet());
        currentVillagers.removeIf(villager -> !villager.isValid() || villager.isDead());
        HashSet<Villager> nearbyVillagers = new HashSet<Villager>();
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 14.0, 7.0, 14.0)) {
            if (entity.getType() != EntityType.VILLAGER) continue;
            nearbyVillagers.add((Villager)entity);
        }
        for (Villager villager2 : nearbyVillagers) {
            if (currentVillagers.contains(villager2)) continue;
            currentVillagers.add(villager2);
            this.startVillagerMovement(player, villager2);
        }
        currentVillagers.removeIf(villager -> !nearbyVillagers.contains(villager));
    }

    private void startVillagerMovement(final Player player, final Villager villager) {
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || !villager.isValid() || villager.isDead() || !VillagerTauntModule.this.playersHoldingEmerald.contains(player) || player.getWorld() != villager.getWorld() || player.getLocation().distanceSquared(villager.getLocation()) > 196.0) {
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    this.cancel();
                    return;
                }
                double distance = player.getLocation().distance(villager.getLocation());
                if (distance <= 1.5) {
                    villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
                    VillagerTauntModule.this.facePlayer(villager, player);
                    return;
                }
                Vector direction = player.getLocation().toVector().subtract(villager.getLocation().toVector()).normalize().multiply(0.16000000000000003);
                villager.setVelocity(new Vector(direction.getX(), villager.getVelocity().getY(), direction.getZ()));
                VillagerTauntModule.this.facePlayer(villager, player);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }

    private void stopVillagerTasks(Player player) {
        UUID playerId = player.getUniqueId();
        Set<Villager> villagers = this.villagerTasks.remove(playerId);
        if (villagers != null) {
            for (Villager villager : villagers) {
                if (!villager.isValid() || villager.isDead()) continue;
                villager.setVelocity(new Vector(0.0, villager.getVelocity().getY(), 0.0));
            }
        }
    }

    private void playEmeraldEffect(Player player) {
        player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
    }

    private void facePlayer(Villager villager, Player player) {
        Location villagerLoc = villager.getLocation();
        Location playerLoc = player.getLocation();
        double dx = playerLoc.getX() - villagerLoc.getX();
        double dz = playerLoc.getZ() - villagerLoc.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        villagerLoc.setYaw(yaw);
        villager.teleport(villagerLoc);
    }
}

