/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.AsyncExecutor;
import com.soystargaze.vitamin.utils.LoggingUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VoidTotemModule
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public VoidTotemModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerFallIntoVoid(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.void_totem") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.void_totem")) {
            return;
        }
        if (player.getLocation().getY() > -59.0) {
            return;
        }
        if (this.isOnCooldown(player)) {
            LoggingUtils.sendMessage(player, "void_totem.cooldown", new Object[0]);
            return;
        }
        boolean totemFromInventoryEnabled = this.plugin.getConfig().getBoolean("modules.totem_from_inventory", true);
        if (totemFromInventoryEnabled ? !this.hasTotemInInventory(player) : !this.hasTotemInHand(player)) {
            LoggingUtils.sendMessage(player, "void_totem.no_totem", new Object[0]);
            return;
        }
        if (this.activateVoidTotem(player, totemFromInventoryEnabled)) {
            this.setCooldown(player);
        }
    }

    private boolean activateVoidTotem(Player player, boolean useInventoryTotem) {
        if (this.removeTotem(player, useInventoryTotem)) {
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 400, 1));
            AsyncExecutor.getExecutor().execute(() -> this.teleportToSafeGround(player));
            LoggingUtils.sendMessage(player, "void_totem.activated", new Object[0]);
            return true;
        }
        return false;
    }

    private boolean hasTotemInInventory(Player player) {
        return player.getInventory().contains(Material.TOTEM_OF_UNDYING);
    }

    private boolean hasTotemInHand(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        return mainHand.getType() == Material.TOTEM_OF_UNDYING || offHand.getType() == Material.TOTEM_OF_UNDYING;
    }

    private boolean removeTotem(Player player, boolean useInventoryTotem) {
        if (useInventoryTotem) {
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != Material.TOTEM_OF_UNDYING) continue;
                item.setAmount(item.getAmount() - 1);
                return true;
            }
        } else {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            ItemStack offHand = player.getInventory().getItemInOffHand();
            if (mainHand.getType() == Material.TOTEM_OF_UNDYING) {
                mainHand.setAmount(mainHand.getAmount() - 1);
                return true;
            }
            if (offHand.getType() == Material.TOTEM_OF_UNDYING) {
                offHand.setAmount(offHand.getAmount() - 1);
                return true;
            }
        }
        return false;
    }

    private void teleportToSafeGround(Player player) {
        World world = player.getWorld();
        Location location = player.getLocation();
        Location safeLocation = null;
        for (int y = world.getMaxHeight(); y > 0; --y) {
            Location testLocation = new Location(world, location.getX(), (double)y, location.getZ());
            if (!this.isSafeLocation(testLocation)) continue;
            safeLocation = testLocation.add(0.0, 1.0, 0.0);
            break;
        }
        if (safeLocation == null) {
            safeLocation = world.getSpawnLocation();
            LoggingUtils.sendMessage(player, "void_totem.teleport_spawn", new Object[0]);
        } else {
            LoggingUtils.sendMessage(player, "void_totem.teleport_safe", new Object[0]);
        }
        Location finalSafeLocation = safeLocation;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.teleport(finalSafeLocation));
    }

    private boolean isSafeLocation(Location location) {
        return !location.getBlock().isPassable() && location.add(0.0, 1.0, 0.0).getBlock().isPassable() && location.add(0.0, 1.0, 0.0).getBlock().isPassable() && !location.getBlock().isLiquid();
    }

    private boolean isOnCooldown(Player player) {
        Long lastUsage = this.cooldowns.get(player.getUniqueId());
        if (lastUsage == null) {
            return false;
        }
        long COOLDOWN_TIME = 30000L;
        return System.currentTimeMillis() - lastUsage < COOLDOWN_TIME;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

