/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WeatherEffectsModule
implements Listener {
    private final JavaPlugin plugin;
    private static final Material[] CROPS = new Material[]{Material.WHEAT, Material.CARROTS, Material.POTATOES, Material.BEETROOTS};

    public WeatherEffectsModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.scheduleCropGrowthTask();
    }

    private void scheduleCropGrowthTask() {
        new BukkitRunnable(){

            public void run() {
                for (World world : WeatherEffectsModule.this.plugin.getServer().getWorlds()) {
                    if (!world.hasStorm()) continue;
                    for (Player player : world.getPlayers()) {
                        if (!player.hasPermission("vitamin.module.weather_effects") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.weather_effects")) continue;
                        Location center = player.getLocation();
                        int radius = 10;
                        for (int x = -radius; x <= radius; ++x) {
                            for (int y = -5; y <= 5; ++y) {
                                for (int z = -radius; z <= radius; ++z) {
                                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                                    Block block = loc.getBlock();
                                    for (Material crop : CROPS) {
                                        int maxAge;
                                        Ageable ageable;
                                        int age;
                                        BlockData blockData;
                                        if (block.getType() != crop || !((blockData = block.getBlockData()) instanceof Ageable) || (age = (ageable = (Ageable)blockData).getAge()) >= (maxAge = ageable.getMaximumAge())) continue;
                                        ageable.setAge(age + 1);
                                        block.setBlockData((BlockData)ageable);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 25000L);
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        World world = event.getEntity().getWorld();
        if (!world.hasStorm()) {
            Location loc = event.getEntity().getLocation();
            world.spawnEntity(loc, event.getEntityType());
        }
    }
}

