/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.paper;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.TranslationHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperElevatorModule
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey keyElevator;
    private final Map<Material, Material> woolToShulkerMap = new HashMap<Material, Material>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();
    private static final long COOLDOWN_MILLIS = 500L;

    public PaperElevatorModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.keyElevator = new NamespacedKey((Plugin)plugin, "elevator");
        this.setupWoolToShulkerMap();
        this.registerRecipe();
    }

    private void setupWoolToShulkerMap() {
        this.woolToShulkerMap.put(Material.WHITE_WOOL, Material.WHITE_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.ORANGE_WOOL, Material.ORANGE_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.MAGENTA_WOOL, Material.MAGENTA_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.LIGHT_BLUE_WOOL, Material.LIGHT_BLUE_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.YELLOW_WOOL, Material.YELLOW_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.LIME_WOOL, Material.LIME_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.PINK_WOOL, Material.PINK_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.GRAY_WOOL, Material.GRAY_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.LIGHT_GRAY_WOOL, Material.LIGHT_GRAY_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.CYAN_WOOL, Material.CYAN_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.PURPLE_WOOL, Material.PURPLE_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.BLUE_WOOL, Material.BLUE_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.BROWN_WOOL, Material.BROWN_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.GREEN_WOOL, Material.GREEN_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.RED_WOOL, Material.RED_SHULKER_BOX);
        this.woolToShulkerMap.put(Material.BLACK_WOOL, Material.BLACK_SHULKER_BOX);
    }

    private void registerRecipe() {
        this.woolToShulkerMap.forEach((woolColor, shulkerColor) -> {
            String colorName = woolColor.name().toLowerCase().replace("_wool", "");
            NamespacedKey recipeKey = new NamespacedKey((Plugin)this.plugin, "elevator_" + colorName);
            Bukkit.removeRecipe((NamespacedKey)recipeKey);
            ItemStack elevator = this.createElevatorItem((Material)shulkerColor);
            ShapedRecipe recipe = new ShapedRecipe(recipeKey, elevator);
            recipe.shape(new String[]{"LLL", "LEL", "LLL"});
            recipe.setIngredient('L', woolColor);
            recipe.setIngredient('E', Material.ENDER_PEARL);
            Bukkit.addRecipe((Recipe)recipe);
        });
    }

    private ItemStack createElevatorItem(Material shulkerColor) {
        ItemStack elevator = new ItemStack(shulkerColor);
        BlockStateMeta meta = (BlockStateMeta)elevator.getItemMeta();
        if (meta != null) {
            meta.displayName(TranslationHandler.getComponent("elevator.item_name", new Object[0]));
            meta.getPersistentDataContainer().set(this.keyElevator, PersistentDataType.BYTE, (Object)1);
            ShulkerBox shulkerBox = (ShulkerBox)meta.getBlockState();
            shulkerBox.getPersistentDataContainer().set(this.keyElevator, PersistentDataType.BYTE, (Object)1);
            meta.setBlockState((BlockState)shulkerBox);
            elevator.setItemMeta((ItemMeta)meta);
        }
        return elevator;
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elevator") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elevator")) {
            return;
        }
        this.teleportElevator(player, 1);
    }

    @EventHandler
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elevator") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elevator")) {
            return;
        }
        if (event.isSneaking()) {
            this.teleportElevator(player, -1);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elevator") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elevator")) {
            return;
        }
        ItemStack item = event.getItemInHand();
        Block block = event.getBlock();
        if (this.woolToShulkerMap.containsValue(block.getType())) {
            BlockState blockState;
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            if (meta.getPersistentDataContainer().has(this.keyElevator, PersistentDataType.BYTE) && (blockState = block.getState()) instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                shulkerBox.getPersistentDataContainer().set(this.keyElevator, PersistentDataType.BYTE, (Object)1);
                shulkerBox.update();
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        ItemStack drop;
        BlockStateMeta meta;
        ShulkerBox shulkerBox;
        BlockState blockState;
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elevator") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elevator")) {
            return;
        }
        Block block = event.getBlock();
        if (this.woolToShulkerMap.containsValue(block.getType()) && (blockState = block.getState()) instanceof ShulkerBox && (shulkerBox = (ShulkerBox)blockState).getPersistentDataContainer().has(this.keyElevator, PersistentDataType.BYTE) && (meta = (BlockStateMeta)(drop = new ItemStack(block.getType())).getItemMeta()) != null) {
            meta.displayName(TranslationHandler.getComponent("elevator.item_name", new Object[0]));
            meta.getPersistentDataContainer().set(this.keyElevator, PersistentDataType.BYTE, (Object)1);
            drop.setItemMeta((ItemMeta)meta);
            event.setCancelled(true);
            block.setType(Material.AIR);
            block.getWorld().dropItemNaturally(block.getLocation(), drop);
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        ShulkerBox shulkerBox;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.hasPermission("vitamin.module.elevator") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elevator")) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof ShulkerBox && (shulkerBox = (ShulkerBox)inventoryHolder).getPersistentDataContainer().has(this.keyElevator, PersistentDataType.BYTE)) {
            event.setCancelled(true);
            UUID uuid = player.getUniqueId();
            if (this.notifiedPlayers.add(uuid)) {
                player.sendMessage(TranslationHandler.getPlayerMessage("elevator.cannot_open", new Object[0]));
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.notifiedPlayers.remove(uuid), 20L);
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (event.getBlocks().stream().anyMatch(this::isElevator)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (event.getBlocks().stream().anyMatch(this::isElevator)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        this.protectElevatorsFromExplosion(event.blockList());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        this.protectElevatorsFromExplosion(event.blockList());
    }

    private void protectElevatorsFromExplosion(List<Block> blocks) {
        blocks.removeIf(this::isElevator);
    }

    private boolean isElevator(Block block) {
        if (!this.woolToShulkerMap.containsValue(block.getType())) {
            return false;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof ShulkerBox) {
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            return shulkerBox.getPersistentDataContainer().has(this.keyElevator, PersistentDataType.BYTE);
        }
        return false;
    }

    private boolean isOnCooldown(Player player) {
        if (!this.cooldowns.containsKey(player.getUniqueId())) {
            return false;
        }
        long lastUse = this.cooldowns.get(player.getUniqueId());
        long currentTime = System.currentTimeMillis();
        return currentTime - lastUse < 500L;
    }

    private void teleportElevator(Player player, int direction) {
        if (this.isOnCooldown(player)) {
            return;
        }
        Block currentBlock = player.getLocation().getBlock().getRelative(0, -1, 0);
        if (!this.isElevator(currentBlock)) {
            return;
        }
        int maxY = player.getWorld().getMaxHeight();
        int minY = player.getWorld().getMinHeight();
        int startY = currentBlock.getY();
        Block targetElevator = null;
        for (int y = startY + direction; y >= minY && y <= maxY; y += direction) {
            Block targetBlock = player.getWorld().getBlockAt(currentBlock.getX(), y, currentBlock.getZ());
            if (!this.isElevator(targetBlock)) continue;
            targetElevator = targetBlock;
            break;
        }
        if (targetElevator != null) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            Location sourceLocation = player.getLocation();
            Location targetLocation = targetElevator.getLocation().add(0.5, 1.0, 0.5);
            player.getWorld().spawnParticle(Particle.SONIC_BOOM, sourceLocation, 5, 0.5, 0.5, 0.5, 0.1);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.teleport(targetLocation);
                player.getWorld().spawnParticle(Particle.SONIC_BOOM, targetLocation, 5, 0.5, 0.5, 0.5, 0.1);
            }, 5L);
        }
    }
}

