/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.paper;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.LoggingUtils;
import com.soystargaze.vitamin.utils.TranslationHandler;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperPlayerXptoBooksModule
implements Listener {
    private final NamespacedKey xpKey;

    public PaperPlayerXptoBooksModule(JavaPlugin plugin) {
        this.xpKey = new NamespacedKey((Plugin)plugin, "xp_amount");
    }

    @EventHandler
    public void onBookConversion(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.xp_books") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.player_xp_to_books")) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.BOOK) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.xpKey, PersistentDataType.INTEGER)) {
            return;
        }
        int totalXp = this.getPlayerTotalXp(player);
        if (totalXp <= 0) {
            return;
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
        ItemStack xpBook = this.createXpBook(totalXp);
        this.setPlayerXp(player, 0);
        if (!player.getInventory().addItem(new ItemStack[]{xpBook}).isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), xpBook);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        LoggingUtils.sendAndLog(player, "xpbook.created", totalXp);
    }

    @EventHandler
    public void onXpBookUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.xp_books") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.player_xp_to_books")) {
            return;
        }
        if (player.isSneaking()) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.BOOK) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.getPersistentDataContainer().has(this.xpKey, PersistentDataType.INTEGER)) {
            return;
        }
        Integer storedXpObj = (Integer)meta.getPersistentDataContainer().get(this.xpKey, PersistentDataType.INTEGER);
        if (storedXpObj == null) {
            return;
        }
        int storedXp = storedXpObj;
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
        int currentXp = this.getPlayerTotalXp(player);
        int newTotalXp = currentXp + storedXp;
        this.setPlayerXp(player, newTotalXp);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        LoggingUtils.sendAndLog(player, "xpbook.used", storedXp);
    }

    private ItemStack createXpBook(int xpAmount) {
        ItemStack xpBook = new ItemStack(Material.BOOK);
        ItemMeta meta = xpBook.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.xpKey, PersistentDataType.INTEGER, (Object)xpAmount);
            meta.displayName(TranslationHandler.getComponent("xpbook.item_name", xpAmount));
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            xpBook.setItemMeta(meta);
        }
        return xpBook;
    }

    private int getPlayerTotalXp(Player player) {
        int level = player.getLevel();
        float progress = player.getExp();
        return (int)((float)this.getXpAtLevel(level) + progress * (float)this.getXpToNextLevel(level));
    }

    private void setPlayerXp(Player player, int totalXp) {
        player.setLevel(0);
        player.setExp(0.0f);
        int level = 0;
        while (this.getXpAtLevel(level + 1) <= totalXp) {
            ++level;
        }
        int xpIntoLevel = totalXp - this.getXpAtLevel(level);
        float progress = this.getXpToNextLevel(level) > 0 ? (float)xpIntoLevel / (float)this.getXpToNextLevel(level) : 0.0f;
        player.setLevel(level);
        player.setExp(progress);
    }

    private int getXpAtLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private int getXpToNextLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }
}

