/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.datagen;

import com.mrbysco.measurements.registration.MeasurementRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MeasurementsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new MeasurementsModels(packOutput));
        generator.addProvider(true, (DataProvider)new MeasurementsRecipeProvider.Runner(packOutput, lookupProvider));
    }

    public static class MeasurementsModels
    extends ModelProvider {
        public MeasurementsModels(PackOutput output) {
            super(output, "measurements");
        }

        protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
            itemModels.generateFlatItem(MeasurementRegistry.TAPE_MEASURE_ITEM.get(), ModelTemplates.FLAT_ITEM);
        }
    }

    public static class MeasurementsRecipeProvider
    extends RecipeProvider {
        public MeasurementsRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            super(registries, output);
        }

        protected void buildRecipes() {
            this.shaped(RecipeCategory.TOOLS, (ItemLike)MeasurementRegistry.TAPE_MEASURE_ITEM.get()).pattern(" G ").pattern("GIY").pattern(" GY").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('G'), (ItemLike)Items.GRAY_WOOL).unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).unlockedBy("has_yellow_wool", this.has((ItemLike)Items.YELLOW_WOOL)).unlockedBy("has_gray_wool", this.has((ItemLike)Items.GRAY_WOOL)).save(this.output);
        }

        private static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
                super(packOutput, lookupProvider);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new MeasurementsRecipeProvider(provider, recipeOutput);
            }

            public String getName() {
                return "Measurements Recipes";
            }
        }
    }
}

