/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mrbysco.measurements.Constants;
import com.mrbysco.measurements.callback.PlayerTickCallback;
import com.mrbysco.measurements.client.ClientClass;
import com.mrbysco.measurements.client.LinePipelines;
import com.mrbysco.measurements.config.MeasurementsConfigFabric;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_310;

public class ClientMeasurementsFabric
implements ClientModInitializer {
    private Thread watchThread = null;
    public static ConfigHolder<MeasurementsConfigFabric> config;

    public void onInitializeClient() {
        ConfigHolder holder;
        config = holder = AutoConfig.register(MeasurementsConfigFabric.class, Toml4jConfigSerializer::new);
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Paths.get("config", new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchThread = new Thread(() -> {
                try {
                    WatchKey key;
                    while ((key = watchService.take()) != null) {
                        if (Thread.currentThread().isInterrupted()) {
                            watchService.close();
                            break;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((Path)event.context()).endsWith("measurements.toml")) continue;
                            Constants.LOGGER.info("Reloading Measurements config");
                            if (!holder.load()) continue;
                            config = holder;
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Failed to close filesystem watcher", (Throwable)e);
                }
            }, "Measurements Config Watcher");
            this.watchThread.start();
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to create filesystem watcher for configs", (Throwable)e);
        }
        PlayerTickCallback.EVENT.register(player -> {
            ClientClass.onPlayerTick(player);
            return class_1269.field_5811;
        });
        WorldRenderEvents.BEFORE_TRANSLUCENT.register(context -> {
            class_310 mc = class_310.method_1551();
            ClientClass.onRenderWorldLast((class_1657)mc.field_1724, mc.field_1773.method_22973(0.0f), context.matrices(), mc.method_22940(), mc.field_1773.method_19418());
        });
        class_10799.method_67887((RenderPipeline)LinePipelines.LINES_NO_DEPTH);
    }
}

