/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mrbysco.measurements.client.BoxHandler;
import com.mrbysco.measurements.client.LineRenderType;
import com.mrbysco.measurements.config.TextColor;
import com.mrbysco.measurements.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class MeasurementBox {
    private final class_2338 startPos;
    private class_2338 endPos;
    public class_238 box;
    private final class_5321<class_1937> dimensionKey;
    private boolean finished;
    private final class_1767 lineColor;
    private final class_1767 textX;
    private final class_1767 textY;
    private final class_1767 textZ;

    MeasurementBox(class_2338 block, class_5321<class_1937> dimensionKey) {
        this.startPos = block;
        this.endPos = block;
        this.dimensionKey = dimensionKey;
        this.finished = false;
        this.lineColor = Services.PLATFORM.getLineColor().getColor(BoxHandler.random);
        TextColor textColor = Services.PLATFORM.getTextColor();
        if (textColor == TextColor.XYZRGB) {
            this.textX = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, class_2350.class_2351.field_11048);
            this.textY = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, class_2350.class_2351.field_11052);
            this.textZ = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, class_2350.class_2351.field_11051);
        } else {
            class_1767 color;
            this.textX = color = textColor.getColor(BoxHandler.random, null);
            this.textY = color;
            this.textZ = color;
        }
        this.setBoundingBox();
    }

    private void setBoundingBox() {
        int ax = this.startPos.method_10263();
        int ay = this.startPos.method_10264();
        int az = this.startPos.method_10260();
        int bx = this.endPos.method_10263();
        int by = this.endPos.method_10264();
        int bz = this.endPos.method_10260();
        this.box = new class_238((double)Math.min(ax, bx), (double)Math.min(ay, by), (double)Math.min(az, bz), (double)(Math.max(ax, bx) + 1), (double)(Math.max(ay, by) + 1), (double)(Math.max(az, bz) + 1));
    }

    public void setBlockEnd(class_2338 blockEnd) {
        this.endPos = blockEnd;
        this.setBoundingBox();
    }

    public void render(class_5321<class_1937> currentDimensionKey, class_4587 poseStack, class_4599 renderBuffers, class_4184 camera, Matrix4f projection) {
        if (!this.dimensionKey.method_29177().equals((Object)currentDimensionKey.method_29177())) {
            return;
        }
        int color = this.lineColor.method_7787();
        float r = (float)class_9848.method_61327((int)color) / 255.0f;
        float g = (float)class_9848.method_61329((int)color) / 255.0f;
        float b = (float)class_9848.method_61331((int)color) / 255.0f;
        float a = 0.95f;
        class_243 pos = camera.method_19326();
        double distance = this.box.method_1005().method_1022(pos);
        float lineWidth = Services.PLATFORM.getLineWidth();
        if (distance > 48.0) {
            lineWidth = Services.PLATFORM.getLineWidthMax();
        }
        class_4597.class_4598 bufferSource = renderBuffers.method_23000();
        poseStack.method_22903();
        class_1921 renderType = LineRenderType.lineRenderType(lineWidth);
        class_4588 builder = bufferSource.method_73477(renderType);
        poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        class_9974.method_62295((class_4587.class_4665)poseStack.method_23760(), (class_4588)builder, (class_238)this.box, (float)r, (float)g, (float)b, (float)0.95f);
        bufferSource.method_22994(renderType);
        poseStack.method_22909();
        this.drawLength(poseStack, camera, projection, bufferSource);
    }

    private void drawLength(class_4587 poseStack, class_4184 camera, Matrix4f projection, class_4597.class_4598 bufferSource) {
        int lengthX = (int)this.box.method_17939();
        int lengthY = (int)this.box.method_17940();
        int lengthZ = (int)this.box.method_17941();
        class_243 pos = camera.method_19326();
        class_4604 clippingHelper = new class_4604(poseStack.method_23760().method_23761(), projection);
        clippingHelper.method_23088(pos.field_1352, pos.field_1351, pos.field_1350);
        class_238 boxT = this.box.method_1014((double)0.08f);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1322, boxT.field_1321, boxT.field_1323, boxT.field_1322, boxT.field_1324), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1325, boxT.field_1321, boxT.field_1323, boxT.field_1325, boxT.field_1324), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1320, boxT.field_1322, boxT.field_1321, boxT.field_1320, boxT.field_1322, boxT.field_1324), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1320, boxT.field_1325, boxT.field_1321, boxT.field_1320, boxT.field_1325, boxT.field_1324), pos));
        Collections.sort(lines);
        class_238 lineZ = ((Line)lines.getFirst()).line;
        class_243 maxZ = lineZ.method_61126();
        class_243 minZ = lineZ.method_61125();
        lines.clear();
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1322, boxT.field_1321, boxT.field_1323, boxT.field_1325, boxT.field_1321), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1322, boxT.field_1324, boxT.field_1323, boxT.field_1325, boxT.field_1324), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1320, boxT.field_1322, boxT.field_1321, boxT.field_1320, boxT.field_1325, boxT.field_1321), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1320, boxT.field_1322, boxT.field_1324, boxT.field_1320, boxT.field_1325, boxT.field_1324), pos));
        Collections.sort(lines);
        class_238 lineY = ((Line)lines.getFirst()).line;
        class_243 maxY = lineY.method_61126();
        class_243 minY = lineY.method_61125();
        lines.clear();
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1322, boxT.field_1321, boxT.field_1320, boxT.field_1322, boxT.field_1321), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1322, boxT.field_1324, boxT.field_1320, boxT.field_1322, boxT.field_1324), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1325, boxT.field_1321, boxT.field_1320, boxT.field_1325, boxT.field_1321), pos));
        lines.add(Line.createLine(new class_238(boxT.field_1323, boxT.field_1325, boxT.field_1324, boxT.field_1320, boxT.field_1325, boxT.field_1324), pos));
        Collections.sort(lines);
        class_238 lineX = ((Line)lines.getFirst()).line;
        class_243 maxX = lineX.method_61126();
        class_243 minX = lineX.method_61125();
        lines.clear();
        class_243 lineXPoint = this.calculateNearestPoint(minX, maxX, pos);
        class_243 lineYPoint = this.calculateNearestPoint(minY, maxY, pos);
        class_243 lineZPoint = this.calculateNearestPoint(minZ, maxZ, pos);
        poseStack.method_22903();
        poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        this.drawText(poseStack, camera, new class_243(lineXPoint.field_1352, lineXPoint.field_1351, lineXPoint.field_1350), (class_2561)class_2561.method_43470((String)String.valueOf(lengthX)), this.textX, bufferSource);
        this.drawText(poseStack, camera, new class_243(lineYPoint.field_1352, lineYPoint.field_1351, lineYPoint.field_1350), (class_2561)class_2561.method_43470((String)String.valueOf(lengthY)), this.textY, bufferSource);
        this.drawText(poseStack, camera, new class_243(lineZPoint.field_1352, lineZPoint.field_1351, lineZPoint.field_1350), (class_2561)class_2561.method_43470((String)String.valueOf(lengthZ)), this.textZ, bufferSource);
        poseStack.method_22909();
    }

    private class_243 calculateNearestPoint(class_243 min, class_243 max, class_243 pos) {
        class_243 lineVec = max.method_1020(min);
        double lineLengthSq = lineVec.method_1027();
        if (lineLengthSq < (double)1.0E-5f) {
            return min;
        }
        double lineLength = Math.sqrt(lineLengthSq);
        if (lineLength < 1.0) {
            return min.method_1019(lineVec.method_1021(0.5));
        }
        class_243 vecFromMinToPos = pos.method_1020(min);
        double t = vecFromMinToPos.method_1026(lineVec) / lineLengthSq;
        double marginFraction = 0.5 / lineLength;
        double t_clamped = class_3532.method_15350((double)t, (double)marginFraction, (double)(1.0 - marginFraction));
        return min.method_1019(lineVec.method_18805(t_clamped, t_clamped, t_clamped));
    }

    private void drawText(class_4587 poseStack, class_4184 camera, class_243 pos, class_2561 length, class_1767 textColor, class_4597.class_4598 bufferSource) {
        class_327 font = class_310.method_1551().field_1772;
        float size = Services.PLATFORM.getTextSize();
        poseStack.method_22903();
        poseStack.method_22904(pos.field_1352, pos.field_1351 + (double)size * 5.0, pos.field_1350);
        poseStack.method_22907((Quaternionfc)camera.method_23767());
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        poseStack.method_22905(-size, -size, -size);
        poseStack.method_46416((float)(-font.method_27525((class_5348)length)) / 2.0f, 0.0f, 0.0f);
        Matrix4f pose = poseStack.method_23760().method_23761();
        font.method_27522(length, 0.0f, 0.0f, textColor.method_16357(), false, pose, (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        poseStack.method_22909();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    private record Line(class_238 line, double distance) implements Comparable<Line>
    {
        public static Line createLine(class_238 line, class_243 pos) {
            return new Line(line, line.method_49271(pos));
        }

        @Override
        public int compareTo(@NotNull Line l) {
            return Double.compare(this.distance, l.distance);
        }
    }
}

