/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mrbysco.measurements.client.MeasurementBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BoxHandler {
    protected static final Random random = new Random();
    private static final List<MeasurementBox> boxList = new ArrayList<MeasurementBox>();

    public static InteractionResult addBox(@NotNull Player playerEntity, @NotNull BlockPos blockPos) {
        if (playerEntity.isShiftKeyDown()) {
            BoxHandler.undo();
            return InteractionResult.SUCCESS;
        }
        if (!boxList.isEmpty()) {
            MeasurementBox lastBox = boxList.getLast();
            if (lastBox.isFinished()) {
                MeasurementBox box = new MeasurementBox(blockPos, (ResourceKey<Level>)playerEntity.level().dimension());
                boxList.add(box);
            } else {
                lastBox.setBlockEnd(blockPos);
                lastBox.setFinished();
            }
        } else {
            MeasurementBox box = new MeasurementBox(blockPos, (ResourceKey<Level>)playerEntity.level().dimension());
            boxList.add(box);
        }
        return InteractionResult.FAIL;
    }

    public static List<MeasurementBox> getBoxList() {
        return boxList;
    }

    public static void undo() {
        if (!boxList.isEmpty()) {
            boxList.removeLast();
        }
    }

    public static void clear() {
        boxList.clear();
    }
}

