/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.quick_chat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.movtery.quick_chat.Constants;
import com.movtery.quick_chat.config.ButtonMessageSendMode;
import com.movtery.quick_chat.config.Message;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Config {
    private final File file;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    private Options options = null;

    public Config(File file) {
        this.file = file;
    }

    public Options getOptions() {
        return this.options;
    }

    public void load() {
        if (this.file.exists()) {
            try {
                this.options = (Options)this.GSON.fromJson((Reader)Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8), Options.class);
                if (this.options != null) {
                    int coolingDuration;
                    int buttonHeight;
                    if (this.options.messageValue != null) {
                        String messageValue = this.options.messageValue;
                        if (messageValue.length() > 256) {
                            this.options.messageValue = messageValue.substring(0, 256);
                        }
                    } else {
                        this.options.messageValue = "Hello!";
                    }
                    if (!this.options.message.isEmpty()) {
                        for (String item : this.options.message) {
                            this.options.messageWithComment.add(new Message(item, ""));
                        }
                        this.options.message.clear();
                    }
                    List<Message> filteredAndDistinct = this.options.messageWithComment.stream().filter(message -> message.getMessage().length() <= 256).distinct().toList();
                    this.options.messageWithComment.clear();
                    this.options.messageWithComment.addAll(filteredAndDistinct);
                    int buttonWidth = this.options.getChatButtonWidth();
                    if (this.options.chatQuickMessageButtonWidth != buttonWidth) {
                        this.options.chatQuickMessageButtonWidth = buttonWidth;
                    }
                    if (this.options.chatQuickMessageButtonHeight != (buttonHeight = this.options.getChatButtonHeight())) {
                        this.options.chatQuickMessageButtonHeight = buttonHeight;
                    }
                    if (this.options.messageCoolingDuration != (coolingDuration = this.options.getCoolingDuration())) {
                        this.options.messageCoolingDuration = coolingDuration;
                    }
                    this.save();
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Error loading config");
            }
        }
        if (this.options == null) {
            this.options = new Options();
            this.save();
        }
    }

    public void save() {
        try {
            Files.write(this.file.toPath(), Collections.singleton(this.GSON.toJson((Object)this.options)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            Constants.LOG.error("Error saving config");
        }
    }

    public static class Options {
        @Expose
        public String messageValue = "Hello!";
        @Expose
        public boolean antiFalseContact = false;
        @Expose
        public boolean chatQuickMessageButton = true;
        @Expose
        public int chatQuickMessageButtonWidth = 80;
        @Expose
        public boolean messageCoolingDown = true;
        @Expose
        public int messageCoolingDuration = 10;
        @Expose
        public boolean displayAsComment = false;
        @Expose
        public int chatQuickMessageButtonHeight = 20;
        @Expose
        public ButtonMessageSendMode buttonMessageSendMode = ButtonMessageSendMode.CLICK_TO_SEND;
        @Expose(serialize=false)
        private final ArrayList<String> message = new ArrayList();
        @Expose
        public ArrayList<Message> messageWithComment = new ArrayList();

        public int getChatButtonWidth() {
            int[] widthRange = new int[]{60, 200};
            return this.chatQuickMessageButtonWidth > widthRange[1] ? widthRange[1] : Math.max(this.chatQuickMessageButtonWidth, widthRange[0]);
        }

        public int getChatButtonHeight() {
            int[] heightRange = new int[]{10, 30};
            return this.chatQuickMessageButtonHeight > heightRange[1] ? heightRange[1] : Math.max(this.chatQuickMessageButtonHeight, heightRange[0]);
        }

        public int getCoolingDuration() {
            int[] durationRange = new int[]{1, 15};
            return this.messageCoolingDuration > durationRange[1] ? durationRange[1] : Math.max(this.messageCoolingDuration, durationRange[0]);
        }
    }
}

