/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.quick_chat.gui;

import com.movtery.quick_chat.Constants;
import com.movtery.quick_chat.config.Config;
import com.movtery.quick_chat.gui.widget.TransparentButton;
import com.movtery.quick_chat.util.QuickChatUtils;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ChatQuickMessageButtons {
    private final class_310 minecraft;
    private final int width;
    private final int height;
    private final Config.Options options = Constants.getConfig().getOptions();

    public ChatQuickMessageButtons(@NotNull class_310 minecraft, int width, int height) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
    }

    public ArrayList<TransparentButton> getAllButton(@NotNull ButtonClickListener listener) {
        ArrayList<TransparentButton> buttons = new ArrayList<TransparentButton>();
        if (this.options.chatQuickMessageButton) {
            int chatWidth = this.minecraft.field_1705.method_1743().method_1811();
            int chatHeight = this.minecraft.field_1705.method_1743().method_1810();
            this.addButton(listener, chatWidth, chatHeight, buttons);
        }
        return buttons;
    }

    private void addButton(@NotNull ButtonClickListener listener, int width, int height, ArrayList<TransparentButton> buttons) {
        int buttonWidth = this.options.getChatButtonWidth();
        int buttonHeight = this.options.getChatButtonHeight();
        ButtonLocation location = new ButtonLocation(width + 18);
        this.options.messageWithComment.forEach(messageObject -> {
            int y = buttonHeight * location.getColumnIndex() + 40;
            if (y - 40 > height) {
                location.addX(buttonWidth);
                location.resetColumnIndex();
                y = buttonHeight * location.getColumnIndex() + 40;
            }
            if (location.getX() + buttonWidth > this.width) {
                return;
            }
            String message = messageObject.getMessage();
            String comment = messageObject.getComment();
            String showOnButton = this.options.displayAsComment && !comment.isEmpty() ? comment : message;
            buttons.add(new TransparentButton.Builder((class_2561)class_2561.method_43470((String)QuickChatUtils.getAbbreviatedText(showOnButton, this.minecraft, buttonWidth - 6)), button -> listener.onClick((TransparentButton)button, message)).dimensions(location.getX(), this.height - y, buttonWidth, buttonHeight).tooltip(class_7919.method_47407((class_2561)QuickChatUtils.getMessageComponent(message, comment))).build());
            location.incrementVerticalSequenceIndex();
        });
    }

    public static interface ButtonClickListener {
        public void onClick(TransparentButton var1, String var2);
    }

    private static class ButtonLocation {
        private int columnIndex = 1;
        private int x;

        public ButtonLocation(int x) {
            this.x = x;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void resetColumnIndex() {
            this.columnIndex = 1;
        }

        public void incrementVerticalSequenceIndex() {
            ++this.columnIndex;
        }

        public int getX() {
            return this.x;
        }

        public void addX(int x) {
            this.x += x + 6;
        }
    }
}

