/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.quick_chat.gui;

import com.movtery.quick_chat.Constants;
import com.movtery.quick_chat.config.Config;
import com.movtery.quick_chat.config.Message;
import com.movtery.quick_chat.gui.AddMessageScreen;
import com.movtery.quick_chat.util.LastMessage;
import com.movtery.quick_chat.util.QuickChatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import org.jetbrains.annotations.NotNull;

public class QuickMessageListScreen
extends class_437 {
    private final class_437 parent;
    private final Config config = Constants.getConfig();
    private class_4185 doneButton;
    private class_4185 removeButton;
    private class_4185 editButton;
    private class_4185 addButton;
    private class_4185 sendButton;
    private MessageListWidget messageListWidget;

    public QuickMessageListScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.bindValues();
        this.messageListWidget = (MessageListWidget)this.method_37063((class_364)new MessageListWidget(this.field_22787));
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.removeButton);
        this.method_37063((class_364)this.editButton);
        this.method_37063((class_364)this.addButton);
        this.method_37063((class_364)this.sendButton);
    }

    private void bindValues() {
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 208, this.field_22790 - 38, 80, 20).method_46431();
        this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.remove"), button -> this.remove()).method_46434(this.field_22789 / 2 - 124, this.field_22790 - 38, 80, 20).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.edit"), button -> this.edit()).method_46434(this.field_22789 / 2 - 40, this.field_22790 - 38, 80, 20).method_46431();
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.add"), button -> this.addMessage()).method_46434(this.field_22789 / 2 + 44, this.field_22790 - 38, 80, 20).method_46431();
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.send"), button -> this.onDone()).method_46434(this.field_22789 / 2 + 128, this.field_22790 - 38, 80, 20).method_46431();
        if (class_310.method_1551().field_1724 == null) {
            this.sendButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"quick_chat.gui.message_list.send_not_in_game")));
            this.sendButton.field_22763 = false;
        }
    }

    public void method_25419() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 16, 0xFFFFFF);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)String.format("(%d) ", this.messageListWidget.method_25396().size())).method_27692(class_124.field_1054).method_10852((class_2561)(this.config.getOptions().messageWithComment.isEmpty() ? class_2561.method_43471((String)"quick_chat.gui.message_list.tip_empty").method_27692(class_124.field_1061) : class_2561.method_43471((String)"quick_chat.gui.message_list.tip").method_27692(class_124.field_1068))), this.field_22789 / 2, this.field_22790 - 54, 0xFFFFFF);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1724 != null && QuickChatUtils.isEnter(keyCode)) {
            this.onDone();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void onDone() {
        MessageListWidget.MessageListEntry messageListEntry = (MessageListWidget.MessageListEntry)this.messageListWidget.method_25334();
        if (this.field_22787 == null) {
            this.method_25419();
        }
        if (messageListEntry != null) {
            QuickChatUtils.sendMessage(this.field_22787, messageListEntry.messageWithComment.get(messageListEntry.abbreviatedText).getMessage());
        }
        this.method_25419();
    }

    private void remove() {
        MessageListWidget.MessageListEntry messageListEntry = (MessageListWidget.MessageListEntry)this.messageListWidget.method_25334();
        if (messageListEntry != null) {
            ArrayList<Message> messageWithComment = this.config.getOptions().messageWithComment;
            if (!messageWithComment.isEmpty()) {
                messageWithComment.remove(messageListEntry.messageWithComment.get(messageListEntry.abbreviatedText));
            }
            this.config.save();
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)this);
        }
    }

    private void addMessage() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507((class_437)new AddMessageScreen(this));
    }

    private void edit() {
        if (this.field_22787 == null) {
            return;
        }
        MessageListWidget.MessageListEntry messageListEntry = (MessageListWidget.MessageListEntry)this.messageListWidget.method_25334();
        if (messageListEntry != null) {
            this.field_22787.method_1507((class_437)new AddMessageScreen(this, messageListEntry.messageWithComment.get(messageListEntry.abbreviatedText)));
        }
    }

    private class MessageListWidget
    extends class_4280<MessageListEntry> {
        public MessageListWidget(class_310 client) {
            super(client, QuickMessageListScreen.this.field_22789, QuickMessageListScreen.this.field_22790 - 93, 32, 18);
            this.reloadMessages(true);
        }

        private void reloadMessages(boolean first) {
            ArrayList<Message> messageList;
            boolean messageIsEmpty;
            if (!first) {
                this.method_25339();
            }
            if (!(messageIsEmpty = (messageList = QuickMessageListScreen.this.config.getOptions().messageWithComment).isEmpty())) {
                AtomicInteger i = new AtomicInteger();
                messageList.forEach(message -> {
                    MessageListEntry entry = new MessageListEntry(this, (Message)message, i.get());
                    this.method_25321((class_350.class_351)entry);
                    if (i.get() == 0 || Objects.equals(message.getMessage(), LastMessage.getInstance().getLastMessage())) {
                        this.method_25313((class_350.class_351)entry);
                    }
                    i.getAndIncrement();
                });
            }
            QuickMessageListScreen.this.removeButton.field_22763 = !messageIsEmpty;
            QuickMessageListScreen.this.editButton.field_22763 = !messageIsEmpty;
            QuickMessageListScreen.this.sendButton.field_22763 = class_310.method_1551().field_1724 != null && !messageIsEmpty;
        }

        public void moveEntryUp(MessageListEntry entry) {
            int index = entry.index;
            if (index > 0) {
                this.moveEntry(index, index - 1);
            }
        }

        public void moveEntryDown(MessageListEntry entry) {
            int index = entry.index;
            if (index < QuickMessageListScreen.this.config.getOptions().messageWithComment.size() - 1) {
                this.moveEntry(index, index + 1);
            }
        }

        private void moveEntry(int index1, int index2) {
            ArrayList<Message> messageWithComment = QuickMessageListScreen.this.config.getOptions().messageWithComment;
            Collections.swap(messageWithComment, index1, index2);
            QuickMessageListScreen.this.config.save();
            this.reloadMessages(false);
        }

        public class MessageListEntry
        extends class_4280.class_4281<MessageListEntry> {
            private final MessageListWidget list;
            final Map<String, Message> messageWithComment = new HashMap<String, Message>();
            final String abbreviatedText;
            private final class_7919 tooltip;
            private long clickTime;
            final int index;

            public MessageListEntry(MessageListWidget listWidget, Message messageObject, int index) {
                this.list = listWidget;
                this.index = index;
                String showOnEntry = QuickMessageListScreen.this.config.getOptions().displayAsComment && !messageObject.getComment().isEmpty() ? messageObject.getComment() : messageObject.getMessage();
                this.abbreviatedText = QuickChatUtils.getAbbreviatedText(showOnEntry, MessageListWidget.this.field_22740, this.list.method_25322() - 30);
                this.messageWithComment.put(this.abbreviatedText, messageObject);
                this.tooltip = class_7919.method_47407((class_2561)QuickChatUtils.getMessageComponent(messageObject));
            }

            public void method_25343(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                class_437 screen;
                int textY = y + 2;
                guiGraphics.method_25300(((MessageListWidget)MessageListWidget.this).field_22740.field_1772, this.abbreviatedText, MessageListWidget.this.field_22758 / 2, textY, 0xFFFFFF);
                int entryX = this.list.method_25342() + this.list.method_25322();
                guiGraphics.method_25303(((MessageListWidget)MessageListWidget.this).field_22740.field_1772, "\u2193", entryX - 11, textY, 0xFFFFFF);
                guiGraphics.method_25303(((MessageListWidget)MessageListWidget.this).field_22740.field_1772, "\u2191", entryX - 20, textY, 0xFFFFFF);
                if (this.method_25405(mouseX, mouseY) && (screen = class_310.method_1551().field_1755) != null) {
                    screen.method_47412(this.tooltip, class_8001.field_41687, this.method_25370());
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                this.onPressed();
                long millis = class_156.method_658();
                int entryX = this.list.method_25342() + this.list.method_25322();
                if (mouseX >= (double)(entryX - 20) && mouseX <= (double)(entryX - 12)) {
                    MessageListWidget.this.moveEntryUp(this);
                    return true;
                }
                if (mouseX >= (double)(entryX - 12) && mouseX <= (double)entryX) {
                    MessageListWidget.this.moveEntryDown(this);
                    return true;
                }
                if (class_310.method_1551().field_1724 != null && millis - this.clickTime < 250L) {
                    QuickMessageListScreen.this.onDone();
                }
                this.clickTime = millis;
                return true;
            }

            void onPressed() {
                MessageListWidget.this.method_25313((class_350.class_351)this);
            }

            @NotNull
            public class_2561 method_37006() {
                return QuickChatUtils.getMessageComponent(this.messageWithComment.get(this.abbreviatedText));
            }
        }
    }
}

