/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.quick_chat.util;

import com.movtery.quick_chat.Constants;
import com.movtery.quick_chat.config.Config;
import com.movtery.quick_chat.config.Message;
import com.movtery.quick_chat.util.LastMessage;
import java.math.BigDecimal;
import java.util.Date;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public final class QuickChatUtils {
    private QuickChatUtils() {
    }

    public static boolean notDoubleClick() {
        LastMessage instance = LastMessage.getInstance();
        long clickTime = class_156.method_658();
        boolean isDoubleClick = clickTime - instance.getLastClick() < 250L;
        instance.setLastClick(clickTime);
        return !isDoubleClick;
    }

    public static String getAbbreviatedText(String message, @NotNull class_310 minecraft, int width) {
        if (minecraft.field_1772.method_1727(message) <= width) {
            return message;
        }
        String text = minecraft.field_1772.method_27523(message, width);
        return text.substring(0, text.length() - 3) + "...";
    }

    public static boolean isEnter(int keyCode) {
        return keyCode == 257 || keyCode == 335;
    }

    public static void sendMessage(@NotNull class_310 minecraft) {
        Config.Options options = Constants.getConfig().getOptions();
        String message = options.messageValue;
        QuickChatUtils.sendMessage(minecraft, message);
    }

    public static void sendMessage(@NotNull class_310 minecraft, String message) {
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        Date date = new Date();
        long timeNum = date.getTime();
        long lastTime = LastMessage.getInstance().getLastTime();
        Config.Options options = Constants.getConfig().getOptions();
        double duration = options.getCoolingDuration();
        long differ = timeNum - lastTime;
        if (!options.messageCoolingDown || lastTime == 0L || (double)differ > 1000.0 * duration) {
            if (differ > 500L) {
                minecraft.field_1705.method_1743().method_1803(message);
                if (!message.startsWith("/")) {
                    player.field_3944.method_45729(message);
                } else {
                    player.field_3944.method_45730(message.substring(1));
                }
                LastMessage.getInstance().setLastTime(timeNum);
                LastMessage.getInstance().setLastMessage(message);
            }
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(duration);
            BigDecimal t = bigDecimal.subtract(BigDecimal.valueOf((double)differ / 1000.0));
            player.method_7353((class_2561)class_2561.method_43471((String)"quick_chat.in_game.too_often").method_27693(String.format(" %.2fs", t)), true);
        }
    }

    public static class_2561 getMessageComponent(Message messageObject) {
        return QuickChatUtils.getMessageComponent(messageObject.getMessage(), messageObject.getComment());
    }

    public static class_2561 getMessageComponent(String message, String comment) {
        class_5250 component = class_2561.method_43470((String)message).method_27693("\n\n");
        if (!comment.isEmpty()) {
            component.method_10852((class_2561)class_2561.method_43471((String)"quick_chat.config.comment.tooltip")).method_27693("\n").method_27693(comment);
        } else {
            component.method_10852((class_2561)class_2561.method_43471((String)"quick_chat.config.no_comment.tooltip"));
        }
        return component;
    }
}

