/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard;

import com.deathmotion.totemguard.TotemGuardAPIImpl;
import com.deathmotion.totemguard.api.TotemGuardProvider;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.events.bukkit.CheckManagerBukkitListener;
import com.deathmotion.totemguard.events.lunarclient.ApolloPlayerListener;
import com.deathmotion.totemguard.events.packets.CheckManagerPacketListener;
import com.deathmotion.totemguard.events.packets.PacketPingListener;
import com.deathmotion.totemguard.events.packets.PacketPlayerJoinQuit;
import com.deathmotion.totemguard.manager.AlertManagerImpl;
import com.deathmotion.totemguard.manager.CloudCommandManager;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.manager.DiscordManager;
import com.deathmotion.totemguard.manager.PlayerDataManager;
import com.deathmotion.totemguard.manager.PunishmentManager;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.redis.RedisService;
import com.deathmotion.totemguard.util.UpdateChecker;
import com.deathmotion.totemguard.util.VersionResolver;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import io.github.retrooper.packetevents.bstats.bukkit.Metrics;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TotemGuard
extends JavaPlugin {
    private static TotemGuard instance;
    private boolean isSupportedVersion = true;
    private ConfigManager configManager;
    private CloudCommandManager cloudCommandManager;
    private DatabaseProvider databaseProvider;
    private MessengerService messengerService;
    private AlertManagerImpl alertManager;
    private PunishmentManager punishmentManager;
    private DiscordManager discordManager;
    private PlayerDataManager playerDataManager;
    private RedisService redisService;
    private UpdateChecker updateChecker;

    public TotemGuard() {
        instance = this;
    }

    public void onLoad() {
        if (!new VersionResolver().isSupportedVersion()) {
            this.isSupportedVersion = false;
            return;
        }
        this.configManager = new ConfigManager(this);
    }

    public void onEnable() {
        if (!this.isSupportedVersion) {
            this.getLogger().severe("Minecraft version " + Bukkit.getMinecraftVersion() + " is not supported by TotemGuard.");
            this.getLogger().severe("We highly recommend updating your server to at least " + VersionResolver.getMinimumSupportedVersion().getReleaseName() + " or later.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.databaseProvider = new DatabaseProvider(this);
        this.messengerService = new MessengerService(this);
        this.alertManager = new AlertManagerImpl(this);
        this.punishmentManager = new PunishmentManager(this);
        this.discordManager = new DiscordManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.redisService = new RedisService(this);
        this.updateChecker = new UpdateChecker(this);
        TotemGuardProvider.setAPI(new TotemGuardAPIImpl(this));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketPlayerJoinQuit(this));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketPingListener());
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new CheckManagerPacketListener());
        this.getServer().getPluginManager().registerEvents((Listener)new CheckManagerBukkitListener(), (Plugin)this);
        new ApolloPlayerListener(this);
        this.cloudCommandManager = new CloudCommandManager(this);
        this.enableBStats();
    }

    public void onDisable() {
        if (this.redisService != null) {
            this.redisService.stop();
        }
        if (this.databaseProvider != null) {
            this.databaseProvider.close();
        }
    }

    public void debug(String message) {
        if (this.configManager.getSettings().isDebug()) {
            String debugMessage = "[TG DEBUG] " + message;
            this.getLogger().info(debugMessage);
            Bukkit.broadcast((String)debugMessage, (String)"TotemGuard.Debug");
        }
    }

    private void enableBStats() {
        new Metrics((Plugin)this, 23179);
    }

    @Generated
    public boolean isSupportedVersion() {
        return this.isSupportedVersion;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public CloudCommandManager getCloudCommandManager() {
        return this.cloudCommandManager;
    }

    @Generated
    public DatabaseProvider getDatabaseProvider() {
        return this.databaseProvider;
    }

    @Generated
    public MessengerService getMessengerService() {
        return this.messengerService;
    }

    @Generated
    public AlertManagerImpl getAlertManager() {
        return this.alertManager;
    }

    @Generated
    public PunishmentManager getPunishmentManager() {
        return this.punishmentManager;
    }

    @Generated
    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    @Generated
    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    @Generated
    public RedisService getRedisService() {
        return this.redisService;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public static TotemGuard getInstance() {
        return instance;
    }
}

