/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.events.FlagEvent;
import com.deathmotion.totemguard.api.interfaces.AbstractCheck;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.config.Settings;
import com.deathmotion.totemguard.interfaces.AbstractCheckSettings;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.datastructure.Pair;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Check
implements AbstractCheck {
    protected final TotemPlayer player;
    private final AtomicInteger violations = new AtomicInteger();
    protected Settings settings;
    protected Messages messages;
    protected Pair<TextColor, TextColor> color;
    protected AbstractCheckSettings checkSettings;
    private String checkName;
    private String description;
    private boolean experimental;

    public Check(TotemPlayer player) {
        this.player = player;
        Class<?> checkClass = this.getClass();
        this.settings = TotemGuard.getInstance().getConfigManager().getSettings();
        this.messages = TotemGuard.getInstance().getConfigManager().getMessages();
        if (checkClass.isAnnotationPresent(CheckData.class)) {
            CheckData checkData = checkClass.getAnnotation(CheckData.class);
            this.checkName = checkData.name();
            this.checkSettings = TotemGuard.getInstance().getConfigManager().getChecks().getCheckSettings(this.checkName);
            this.description = checkData.description();
            this.experimental = checkData.experimental();
        }
        this.color = this.getColors();
    }

    @Override
    public void reload() {
        this.settings = TotemGuard.getInstance().getConfigManager().getSettings();
        this.messages = TotemGuard.getInstance().getConfigManager().getMessages();
        Class<?> checkClass = this.getClass();
        if (checkClass.isAnnotationPresent(CheckData.class)) {
            this.checkSettings = TotemGuard.getInstance().getConfigManager().getChecks().getCheckSettings(this.checkName);
        }
        this.color = this.getColors();
    }

    public void fail() {
        this.fail((Component)Component.empty());
    }

    public void fail(Component details) {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)TotemGuard.getInstance(), O -> {
            if (!this.shouldFail()) {
                return;
            }
            this.violations.incrementAndGet();
            TotemGuard.getInstance().getAlertManager().sendAlert(this, details);
            TotemGuard.getInstance().getPunishmentManager().punishPlayer(this, details);
        });
    }

    public boolean shouldFail() {
        if (!this.checkSettings.isEnabled()) {
            return false;
        }
        if (this.settings.isApi()) {
            FlagEvent event = new FlagEvent(this.player, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    @Override
    public int getViolations() {
        return this.violations.get();
    }

    @Override
    public int getMaxViolations() {
        return this.checkSettings.getMaxViolations();
    }

    private Pair<TextColor, TextColor> getColors() {
        MessengerService messengerService = TotemGuard.getInstance().getMessengerService();
        Messages.AlertFormat.CheckDetailsColor colorScheme = this.messages.getAlertFormat().getCheckDetailsColor();
        TextColor primaryColor = messengerService.format(colorScheme.getMain()).color();
        TextColor secondaryColor = messengerService.format(colorScheme.getSecondary()).color();
        return new Pair<TextColor, TextColor>(primaryColor, secondaryColor);
    }

    @Generated
    public TotemPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public Pair<TextColor, TextColor> getColor() {
        return this.color;
    }

    @Generated
    public AbstractCheckSettings getCheckSettings() {
        return this.checkSettings;
    }

    @Override
    @Generated
    public String getCheckName() {
        return this.checkName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public boolean isExperimental() {
        return this.experimental;
    }
}

