/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks;

import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.SignCheck;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.SignUtil;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUpdateSign;
import java.util.List;
import java.util.UUID;

public abstract class ModCheck
extends Check
implements SignCheck {
    private final UUID packetSecret = UUID.randomUUID();
    private final List<String> keys;

    public ModCheck(TotemPlayer player, List<String> keys) {
        super(player);
        Class<?> checkClass = this.getClass();
        if (!checkClass.isAnnotationPresent(CheckData.class)) {
            throw new IllegalArgumentException("Check class must be annotated with @CheckData");
        }
        CheckData checkData = checkClass.getAnnotation(CheckData.class);
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("The check " + checkData.name() + " doesn't specify any detections");
        }
        if (keys.size() > 3) {
            throw new IllegalArgumentException("The check " + checkData.name() + " specifies more than 3 detections");
        }
        this.keys = keys;
    }

    @Override
    public void placeSign() {
        SignUtil.placeSign(this.player, this.packetSecret, this.keys);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        String[] lines;
        if (event.getPacketType() != PacketType.Play.Client.UPDATE_SIGN) {
            return;
        }
        try {
            lines = new WrapperPlayClientUpdateSign(event).getTextLines();
        }
        catch (Exception e) {
            return;
        }
        if (SignUtil.isSignContentValid(this.packetSecret, lines, this.keys)) {
            this.fail();
        }
    }
}

