/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.MathUtil;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="AutoTotemB", description="Suspicious standard deviation")
public class AutoTotemB
extends Check
implements BukkitEventCheck {
    private int lowStandardDeviationCount = 0;

    public AutoTotemB(TotemPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onTotemCycleEvent() {
        List<Long> intervals = this.player.totemData.getLatestIntervals(2);
        if (intervals.size() < 2) {
            return;
        }
        double standardDeviation = MathUtil.getStandardDeviation(intervals);
        double mean = MathUtil.getMean(intervals);
        Checks.AutoTotemB settings = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemB();
        if (standardDeviation >= settings.getStandardDeviationThreshold()) {
            return;
        }
        if (mean >= settings.getMeanThreshold()) {
            return;
        }
        ++this.lowStandardDeviationCount;
        if (this.lowStandardDeviationCount >= settings.getConsecutiveLowSDCount()) {
            this.lowStandardDeviationCount = 0;
            this.fail(this.createComponent(standardDeviation, mean));
        }
    }

    private Component createComponent(double standardDeviation, double mean) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Standard Deviation: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((double)MathUtil.trim(2, standardDeviation), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Mean: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(MathUtil.trim(2, mean) + "ms"), (TextColor)((TextColor)this.color.getY())))).build();
    }
}

