/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="AutoTotemC", description="Suspicious average standard deviation")
public class AutoTotemC
extends Check
implements BukkitEventCheck {
    private final ConcurrentLinkedDeque<Double> standardDeviations = new ConcurrentLinkedDeque();
    private int consistentStandardDeviationCount = 0;

    public AutoTotemC(TotemPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onTotemCycleEvent() {
        List<Long> recentIntervals = this.player.totemData.getLatestIntervals(4);
        double standardDeviation = MathUtil.getStandardDeviation(recentIntervals);
        this.standardDeviations.addLast(standardDeviation);
        while (this.standardDeviations.size() > 4) {
            this.standardDeviations.pollFirst();
        }
        if (this.standardDeviations.size() >= 2) {
            Checks.AutoTotemC settings;
            ArrayList<Double> sdList = new ArrayList<Double>(this.standardDeviations);
            ArrayList<Double> differences = new ArrayList<Double>();
            for (int i = 1; i < sdList.size(); ++i) {
                differences.add(Math.abs((Double)sdList.get(i) - (Double)sdList.get(i - 1)));
            }
            double averageSDDifference = MathUtil.getMean(differences);
            if (averageSDDifference < (settings = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemC()).getConsistentSDRange()) {
                ++this.consistentStandardDeviationCount;
                if (this.consistentStandardDeviationCount >= settings.getConsecutiveViolations()) {
                    this.standardDeviations.clear();
                    this.consistentStandardDeviationCount = 0;
                    this.fail(this.createComponent(averageSDDifference));
                }
            } else {
                this.consistentStandardDeviationCount = 0;
            }
        }
    }

    private Component createComponent(double averageSDDifference) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Average SD Difference: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((double)MathUtil.trim(2, averageSDDifference), (TextColor)((TextColor)this.color.getY())))).build();
    }
}

