/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.PacketCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.models.impl.DigAndPickupState;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="AutoTotemD", description="Suspicious re-totem packet sequence")
public class AutoTotemD
extends Check
implements PacketCheck {
    private static final long EXPECTED_AVERAGE_TIME = 50L;
    private static final long ACCEPTABLE_VARIATION = 20L;

    public AutoTotemD(TotemPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            if (this.player.totemData.getLastTotemUsage() == null) {
                return;
            }
            WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(event);
            if (packet.getAction() == DiggingAction.SWAP_ITEM_WITH_OFFHAND) {
                this.handleDiggingPacket();
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.PICK_ITEM) {
            this.handlePickItemPacket();
        }
    }

    private void handleDiggingPacket() {
        long currentTime = System.currentTimeMillis();
        if (this.player.digAndPickupState.sequence == 0 || this.player.digAndPickupState.sequence == 2) {
            ++this.player.digAndPickupState.sequence;
            this.player.digAndPickupState.lastDiggingPacketTime = currentTime;
        }
        if (this.player.digAndPickupState.sequence == 3) {
            long totemPopTime = this.player.totemData.getLastTotemUsage();
            long totalPacketTime = currentTime - totemPopTime;
            long averageTimePerPacket = totalPacketTime / 3L;
            long timeToFirstDigging = this.player.digAndPickupState.firstPacketTime - totemPopTime;
            long timeToPickItem = this.player.digAndPickupState.timeToPickItem;
            long timeFromPickToLastDigging = currentTime - this.player.digAndPickupState.pickItemPacketTime;
            Checks.AutoTotemD settings = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemD();
            if (this.isWithinExpectedRange(averageTimePerPacket)) {
                this.fail(this.createComponent(totalPacketTime, averageTimePerPacket, timeToFirstDigging, timeToPickItem, timeFromPickToLastDigging));
            }
            this.player.digAndPickupState = new DigAndPickupState();
        } else if (this.player.digAndPickupState.sequence == 1) {
            this.player.digAndPickupState.firstPacketTime = currentTime;
        }
    }

    private void handlePickItemPacket() {
        long currentTime = System.currentTimeMillis();
        if (this.player.digAndPickupState.sequence == 1) {
            ++this.player.digAndPickupState.sequence;
            this.player.digAndPickupState.pickItemPacketTime = currentTime;
            this.player.digAndPickupState.timeToPickItem = currentTime - this.player.digAndPickupState.firstPacketTime;
        }
    }

    private boolean isWithinExpectedRange(long averageTime) {
        return Math.abs(averageTime - 50L) <= 20L;
    }

    private Component createComponent(long totalPacketTime, long averageTimePerPacket, long timeToFirstDigging, long timeToPickItem, long timeFromPickToLastDigging) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Total time: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(totalPacketTime + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Average time per packet: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(averageTimePerPacket + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Time to first swap packet: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(timeToFirstDigging + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Time from swap -> pick up: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(timeToPickItem + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Time from pick up -> digging: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(timeFromPickToLastDigging + "ms"), (TextColor)((TextColor)this.color.getY())))).build();
    }
}

