/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.MathUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="AutoTotemE", description="Suspicious low outliers")
public class AutoTotemE
extends Check
implements BukkitEventCheck {
    private final ConcurrentLinkedDeque<Double> lowOutliersTracker = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Double> averageStandardDeviation = new ConcurrentLinkedDeque();

    public AutoTotemE(TotemPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onTotemCycleEvent() {
        List<Long> intervals = this.player.totemData.getLatestIntervals(15);
        if (intervals.size() < 4) {
            return;
        }
        List<Double> lowOutliers = MathUtil.getOutliers(intervals).getX();
        this.lowOutliersTracker.addAll(lowOutliers);
        while (this.lowOutliersTracker.size() > 30) {
            this.lowOutliersTracker.poll();
        }
        if (this.lowOutliersTracker.size() >= 15) {
            double standardDeviation = MathUtil.getStandardDeviation(this.lowOutliersTracker);
            this.averageStandardDeviation.addLast(standardDeviation);
            while (this.averageStandardDeviation.size() > 10) {
                this.averageStandardDeviation.poll();
            }
            double averageStDeviation = MathUtil.getMean(this.averageStandardDeviation);
            Checks.AutoTotemE settings = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemE();
            if (standardDeviation < settings.getStandardDeviationThreshold() && averageStDeviation < settings.getAverageStDeviationThreshold()) {
                this.fail(this.createComponent(standardDeviation, averageStDeviation));
            }
        }
    }

    private Component createComponent(double standardDeviation, double averageStDeviation) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Standard Deviation: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(MathUtil.trim(2, standardDeviation) + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Average Stdev Mean: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((double)MathUtil.trim(2, averageStDeviation), (TextColor)((TextColor)this.color.getY())))).build();
    }
}

