/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.models.impl.ValidClickTypes;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@CheckData(name="AutoTotemF", description="Invalid interaction", experimental=true)
public class AutoTotemF
extends Check
implements BukkitEventCheck {
    private Long inventoryClickTime;

    public AutoTotemF(TotemPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onBukkitEvent(Event event) {
        if (event instanceof InventoryClickEvent) {
            this.handleInventoryClick((InventoryClickEvent)event);
        } else if (event instanceof PlayerInteractEvent) {
            this.handlePlayerInteract((PlayerInteractEvent)event);
        } else if (event instanceof InventoryCloseEvent) {
            this.handleInventoryClose();
        } else if (event instanceof PlayerDeathEvent) {
            this.handlePlayerDeath();
        }
    }

    private void handleInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getClickedInventory();
        if (inventory == null || inventory.getType() != InventoryType.PLAYER) {
            return;
        }
        if (!ValidClickTypes.isClickTypeValid(event.getClick())) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        int hotbar = event.getHotbarButton();
        ItemStack hotbarItem = null;
        if (hotbar >= 0) {
            hotbarItem = this.player.bukkitPlayer.getInventory().getItem(hotbar);
        }
        if (item != null && item.getType() == Material.TOTEM_OF_UNDYING || hotbarItem != null && hotbarItem.getType() == Material.TOTEM_OF_UNDYING) {
            this.inventoryClickTime = System.currentTimeMillis();
        }
    }

    private void handlePlayerInteract(PlayerInteractEvent event) {
        if (this.inventoryClickTime == null) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.PHYSICAL) {
            return;
        }
        this.checkSuspiciousActivity(action);
        this.inventoryClickTime = null;
    }

    private void checkSuspiciousActivity(Action action) {
        Checks.AutoTotemF settings;
        long timeDifference = Math.abs(System.currentTimeMillis() - this.inventoryClickTime);
        if (timeDifference <= (long)(settings = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemF()).getTimeDifference()) {
            this.fail(this.createDetails(action, timeDifference));
        }
    }

    private void handleInventoryClose() {
        this.inventoryClickTime = null;
    }

    private void handlePlayerDeath() {
        this.inventoryClickTime = null;
    }

    private Component createDetails(Action action, Long timeDifference) {
        BuildableComponent component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Type: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)action.toString(), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Time Difference: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((long)timeDifference, (TextColor)((TextColor)this.color.getY())))).append((Component)Component.text((String)"ms", (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Main Hand: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)this.getMainHandItemString(), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).build();
        StringBuilder states = new StringBuilder();
        if (this.player.bukkitPlayer.isSprinting()) {
            states.append("Sprinting, ");
        }
        if (this.player.bukkitPlayer.isSneaking()) {
            states.append("Sneaking, ");
        }
        if (this.player.bukkitPlayer.isBlocking()) {
            states.append("Blocking, ");
        }
        if (!states.isEmpty()) {
            states.setLength(states.length() - 2);
            component = component.append((Component)Component.text((String)"States: ", (TextColor)((TextColor)this.color.getX()))).append((Component)Component.text((String)states.toString(), (TextColor)((TextColor)this.color.getY())));
        }
        return component;
    }

    private String getMainHandItemString() {
        PlayerInventory inventory = this.player.bukkitPlayer.getInventory();
        return inventory.getItemInMainHand().getType() == Material.AIR ? "Empty Hand" : inventory.getItemInMainHand().getType().toString();
    }
}

