/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.autototem;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.models.TotemPlayer;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@CheckData(name="AutoTotemG", description="Monitors swap-hand timings")
public class AutoTotemG
extends Check
implements BukkitEventCheck {
    private Long lastTotemUse;
    private Long lastClickTime;

    public AutoTotemG(TotemPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onBukkitEvent(Event event) {
        if (event instanceof EntityResurrectEvent) {
            this.handleEntityResurrection();
        }
        if (event instanceof InventoryClickEvent) {
            InventoryClickEvent invClickEvent = (InventoryClickEvent)event;
            this.handleInventoryClick(invClickEvent);
        }
        if (event instanceof PlayerSwapHandItemsEvent) {
            PlayerSwapHandItemsEvent swapHandItemsEvent = (PlayerSwapHandItemsEvent)event;
            this.handleSwapHandItems(swapHandItemsEvent);
        }
    }

    private void handleEntityResurrection() {
        PlayerInventory playerInventory = this.player.bukkitPlayer.getInventory();
        if (playerInventory.getItemInMainHand().getType() == Material.TOTEM_OF_UNDYING) {
            return;
        }
        if (!playerInventory.containsAtLeast(new ItemStack(Material.TOTEM_OF_UNDYING), 2)) {
            return;
        }
        this.lastTotemUse = System.currentTimeMillis();
    }

    private void handleInventoryClick(InventoryClickEvent event) {
        ClickType click = event.getClick();
        if (click == ClickType.NUMBER_KEY || click == ClickType.SHIFT_LEFT || click == ClickType.SHIFT_RIGHT) {
            ItemStack item = event.getCurrentItem();
            int hotbar = event.getHotbarButton();
            ItemStack hotbarItem = null;
            if (hotbar >= 0) {
                hotbarItem = this.player.bukkitPlayer.getInventory().getItem(hotbar);
            }
            if (item != null && item.getType() == Material.TOTEM_OF_UNDYING || hotbarItem != null && hotbarItem.getType() == Material.TOTEM_OF_UNDYING) {
                this.lastClickTime = System.currentTimeMillis();
            }
        }
    }

    private void handleSwapHandItems(PlayerSwapHandItemsEvent event) {
        if (event.getOffHandItem().getType() == Material.TOTEM_OF_UNDYING && this.lastClickTime != null && this.lastTotemUse != null) {
            this.evaluateSuspicion();
        }
    }

    private void evaluateSuspicion() {
        long now = System.currentTimeMillis();
        long timeSinceTotemUse = Math.abs(now - this.lastTotemUse);
        long timeSinceClick = Math.abs(now - this.lastClickTime);
        long adjustedTotemTime = Math.abs(timeSinceTotemUse - (long)this.player.getKeepAlivePing());
        Checks.AutoTotemG config = TotemGuard.getInstance().getConfigManager().getChecks().getAutoTotemG();
        if (timeSinceClick <= (long)config.getClickToSwapTimeDifference() && timeSinceTotemUse <= (long)config.getNormalCheckTimeMs()) {
            this.fail(this.createDetails(timeSinceTotemUse, adjustedTotemTime, timeSinceClick));
        }
        this.lastTotemUse = null;
    }

    private Component createDetails(long timeDifference, long realTotemTime, long clickTimeDifference) {
        BuildableComponent component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Totem Time: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(timeDifference + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Real Totem Time: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(realTotemTime + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Click Difference: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)(clickTimeDifference + "ms"), (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Main Hand: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)this.getMainHandItemString(), (TextColor)((TextColor)this.color.getY())))).build();
        StringBuilder states = new StringBuilder();
        if (this.player.bukkitPlayer.isSprinting()) {
            states.append("Sprinting, ");
        }
        if (this.player.bukkitPlayer.isSneaking()) {
            states.append("Sneaking, ");
        }
        if (this.player.bukkitPlayer.isBlocking()) {
            states.append("Blocking, ");
        }
        if (!states.isEmpty()) {
            states.setLength(states.length() - 2);
            component = component.append((Component)Component.newline()).append((Component)Component.text((String)"States: ", (TextColor)((TextColor)this.color.getX()))).append((Component)Component.text((String)states.toString(), (TextColor)((TextColor)this.color.getY())));
        }
        return component;
    }

    private String getMainHandItemString() {
        PlayerInventory inventory = this.player.bukkitPlayer.getInventory();
        return inventory.getItemInMainHand().getType() == Material.AIR ? "Empty Hand" : inventory.getItemInMainHand().getType().toString();
    }
}

