/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.badpackets;

import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.PacketCheck;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.configuration.client.WrapperConfigClientPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="BadPacketsA", description="Suspicious mod message")
public class BadPacketsA
extends Check
implements PacketCheck {
    private static final String SUSPICIOUS_CHANNEL_KEYWORD = "autototem";

    public BadPacketsA(TotemPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage packet = new WrapperPlayClientPluginMessage(event);
            this.handle(packet.getChannelName());
        } else if (event.getPacketType() == PacketType.Configuration.Client.PLUGIN_MESSAGE) {
            WrapperConfigClientPluginMessage packet = new WrapperConfigClientPluginMessage(event);
            this.handle(packet.getChannelName());
        }
    }

    private void handle(String channel) {
        if (channel == null || !channel.toLowerCase().contains(SUSPICIOUS_CHANNEL_KEYWORD)) {
            return;
        }
        this.fail(this.getCheckDetails(channel));
    }

    private Component getCheckDetails(String channel) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Channel: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((String)channel, (TextColor)((TextColor)this.color.getY())))).build();
    }
}

