/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.badpackets;

import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.CheckData;
import com.deathmotion.totemguard.checks.type.PacketCheck;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

@CheckData(name="BadPacketsC", description="Impossible same slot packet")
public class BadPacketsC
extends Check
implements PacketCheck {
    int lastSlot = -69;

    public BadPacketsC(TotemPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.HELD_ITEM_CHANGE) {
            return;
        }
        int slot = new WrapperPlayClientHeldItemChange(event).getSlot();
        if (slot == this.lastSlot) {
            this.fail(this.createDetails(slot, this.lastSlot));
        }
        this.lastSlot = slot;
    }

    private Component createDetails(int slot, int lastSlot) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"New Slot Change: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((int)slot, (TextColor)((TextColor)this.color.getY())))).append((Component)Component.newline())).append((Component)Component.text((String)"Last Slot Change: ", (TextColor)((TextColor)this.color.getX())))).append((Component)Component.text((int)lastSlot, (TextColor)((TextColor)this.color.getY())))).build();
    }
}

