/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.checks.impl.misc;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.checks.type.PacketCheck;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.ChatUtil;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.configuration.client.WrapperConfigClientPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ClientBrand
extends Check
implements PacketCheck {
    private static final String CHANNEL = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? "minecraft:brand" : "MC|Brand";
    private String brand = "vanilla";
    private boolean hasBrand = false;

    public ClientBrand(TotemPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage packet = new WrapperPlayClientPluginMessage(event);
            this.handle(packet.getChannelName(), packet.getData());
        } else if (event.getPacketType() == PacketType.Configuration.Client.PLUGIN_MESSAGE) {
            WrapperConfigClientPluginMessage packet = new WrapperConfigClientPluginMessage(event);
            this.handle(packet.getChannelName(), packet.getData());
        }
    }

    private void handle(String channel, byte[] data) {
        if (!channel.equals(CHANNEL)) {
            return;
        }
        if (data.length > 64 || data.length == 0) {
            this.brand = "sent " + data.length + " bytes as brand";
        } else if (!this.hasBrand) {
            byte[] minusLength = new byte[data.length - 1];
            System.arraycopy(data, 1, minusLength, 0, minusLength.length);
            this.brand = new String(minusLength).replace(" (Velocity)", "");
            this.brand = ChatUtil.stripColor(this.brand);
            this.announceBrand();
        }
        this.hasBrand = true;
    }

    private void announceBrand() {
        if (!this.settings.isAnnounceClientBrand()) {
            return;
        }
        String alertBrandTemplate = TotemGuard.getInstance().getConfigManager().getMessages().getAlertBrand();
        Component brandAlert = TotemGuard.getInstance().getMessengerService().format(alertBrandTemplate.replace("%prefix%", this.messages.getPrefix()).replace("%player%", this.player.getName()).replace("%client_brand%", this.brand));
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.hasPermission("TotemGuard.Brand")) continue;
            onlinePlayer.sendMessage(brandAlert);
        }
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }
}

