/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.commands.arguments.PlayerSuggestion;
import com.deathmotion.totemguard.manager.AlertManagerImpl;
import com.deathmotion.totemguard.messenger.CommandMessengerService;
import com.deathmotion.totemguard.messenger.MessengerService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.parser.PlayerParser;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;

public final class AlertsCommand
extends AbstractCommand {
    private final MessengerService messengerService;
    private final CommandMessengerService commandMessengerService;
    private final AlertManagerImpl alertManager;

    public AlertsCommand(TotemGuard plugin) {
        this.messengerService = plugin.getMessengerService();
        this.commandMessengerService = this.messengerService.getCommandMessengerService();
        this.alertManager = plugin.getAlertManager();
    }

    private static boolean isSelf(@NonNull Player player, @NonNull Player target) {
        return player.getUniqueId().equals(target.getUniqueId());
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("alerts", Description.of((String)"Toggle alerts for yourself or another player"), new String[0]).optional("target", PlayerParser.playerParser(), PlayerSuggestion.onlinePlayerSuggestions()).permission(this.perm("Alerts")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        CommandSender sender = (CommandSender)ctx.sender();
        Player target = (Player)ctx.getOrDefault("target", null);
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)sender;
            this.handleConsole(console, target);
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.handlePlayer(player, target);
            return;
        }
        sender.sendMessage((Component)Component.text((String)"This command can only be used by players or from the console.", (TextColor)NamedTextColor.RED));
    }

    private void handleConsole(@NonNull ConsoleCommandSender console, Player target) {
        if (target == null) {
            console.sendMessage(this.commandMessengerService.specifyPlayer());
            return;
        }
        this.toggleForTarget((CommandSender)console, target);
    }

    private void handlePlayer(@NonNull Player player, Player target) {
        if (target == null || AlertsCommand.isSelf(player, target)) {
            this.alertManager.toggleAlerts(player);
            return;
        }
        if (!player.hasPermission(this.perm("alerts.others"))) {
            player.sendMessage(this.messengerService.toggleAlertsOtherNoPermission());
            return;
        }
        this.toggleForTarget((CommandSender)player, target);
    }

    private void toggleForTarget(@NonNull CommandSender sender, @NonNull Player target) {
        boolean success = this.alertManager.toggleAlerts(target);
        if (!success) {
            sender.sendMessage(this.messengerService.toggleAlertsBlockedExternal());
            return;
        }
        boolean nowEnabled = this.alertManager.hasAlertsEnabled(target);
        Component feedback = this.messengerService.toggleAlertsOther(nowEnabled, target.getName());
        sender.sendMessage(feedback);
    }
}

